/*******************************************************\
* irmp3-ncurses - An ncurses frontend for irmp3 using   *
* the Network Control Module                            *
* (C) 2003 Ross Axe                                     *
*                                                       *
* scroller-stub.c - Draw non-scrolling text             *
\*******************************************************/

#if HAVE_CONFIG_H
#  include "config.h"
#endif

#include "irmp3-ncurses.h"

vcid("$Id: stub-scroller.c,v 1.5 2005/12/30 13:18:48 ross Exp $");


void block_scroller(void)
{
    return;
}

void unblock_scroller(void)
{
    return;
}

void wscroller_hook(WINDOW **wnd, struct scroller *scroller, const char *msg,
		    bool right, void *(*entryhook)(struct scroller *),
		    void (*exithook)(struct scroller *, void *))
{
    int x, y;
    int w, h;
    void *hookdata;

    getyx(*wnd, y, x);
    getmaxyx(*wnd, h, w);
    w -= x;
    *scroller = (struct scroller) {
	.wnd = wnd,
	.msg = msg,
	.x = x,
	.y = y,
	.len = w,
	.pos = right ? strlen(msg) - w : 0,
	.dir = right ? +1 : -1,
	.entryhook = entryhook,
	.exithook = exithook,
    };
    hookdata = entryhook ? entryhook(scroller) : NULL;
    wprintw(*wnd, "%-*.*s", w, w, msg + (scroller->pos > 0
					? scroller->pos : 0));
    if(exithook)
	exithook(scroller, hookdata);
    *scroller = (struct scroller)SCROLLER_INITIALISER;
}

void scroller_end(struct scroller *scroller)
{
    *scroller = (struct scroller)SCROLLER_INITIALISER;
}

void scroller_endall(void)
{
    return;
}
