/*
 * msg_input_dialog.h - declaration of class msgInputDialog
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _MSG_INPUT_DIALOG_H
#define _MSG_INPUT_DIALOG_H

#include <qdialog.h>


/*!
  \brief The Message-Input-Dialog

  With the help of this dialog you can input a message, which should be displayed on one or more client(s).

  \sa   clientManager for detailed description of management of clients
*/

class QLabel;
class QTextEdit;
class QPushButton;


class msgInputDialog : public QDialog
{
	Q_OBJECT
public:
	msgInputDialog( QString & _msg_str, QWidget * _parent );
	~msgInputDialog();


private slots:
	virtual void accept( void );


private:
	void keyPressEvent( QKeyEvent * _ke );
	void resizeEvent( QResizeEvent * _re );

	QPushButton * m_cancelBtn;
	QPushButton * m_okBtn;
	QLabel * m_iconLbl;
	QLabel * m_appNameLbl;
	QTextEdit * m_msgInputTextEdit;

	QString & m_msgStr;
} ;

#endif
