#-------------------------------------------------------------------------------
# Project:     DLX
# File:        TBdlx.do
# Description: Script to simulate DLX with IVI
#-------------------------------------------------------------------------------

# create working directories
file mkdir _work
file mkdir _run
cd _run

# import sources to library, make simulator
eval ghdl -i --workdir=../_work [glob ../src/*.vhdl]
eval ghdl -m --workdir=../_work dlx_test_behaviour
file rename -force dlx_test_behaviour dlx_test_behaviour.ghdl

# copy the program code
file copy -force ../src/test_loop.out dlx.out

# load design, setup wave window, run simulation
load_design dlx_test_behaviour.ghdl
do ../dlx_ghdl_wave.do
run 6500ns

#-------------------------------------------------------------------------------
# end of file
