--------------------------------------------------------------------------------
-- File:        TBpak.vhd
-- Description: OPB testbench package.
--------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;

package OpbPak is
	
	procedure OPB_read(
	a                   :     std_logic_vector(0 to 31); 
	d                   :     std_logic_vector(0 to 31); 
	be                  :     std_logic_vector(0 to 3);
	--
	signal OPB_Clk      : in  std_logic;
	signal OPB_Rst      : in  std_logic;
	signal Interrupt    : in  std_logic;
	signal OPB_ABus     : out std_logic_vector(0 to 31);
	signal OPB_BE       : out std_logic_vector(0 to 3);
	signal OPB_DBus     : out std_logic_vector(0 to 31);
	signal OPB_RNW      : out std_logic;
	signal OPB_select   : out std_logic;
	signal OPB_seqAddr  : out std_logic;
	signal Sln_DBus     : in  std_logic_vector(0 to 31);
	signal Sln_errAck   : in  std_logic;
	signal Sln_retry    : in  std_logic;
	signal Sln_toutSup  : in  std_logic;
	signal Sln_xferAck  : in  std_logic);
	
	------------------------------------
	procedure OPB_write(
	a                   :     std_logic_vector(0 to 31); 
	d                   :     std_logic_vector(0 to 31); 
	be                  :     std_logic_vector(0 to 3);
	--
	signal OPB_Clk      : in  std_logic;
	signal OPB_Rst      : in  std_logic;
	signal Interrupt    : in  std_logic;
	signal OPB_ABus     : out std_logic_vector(0 to 31);
	signal OPB_BE       : out std_logic_vector(0 to 3);
	signal OPB_DBus     : out std_logic_vector(0 to 31);
	signal OPB_RNW      : out std_logic;
	signal OPB_select   : out std_logic;
	signal OPB_seqAddr  : out std_logic;
	signal Sln_DBus     : in  std_logic_vector(0 to 31);
	signal Sln_errAck   : in  std_logic;
	signal Sln_retry    : in  std_logic;
	signal Sln_toutSup  : in  std_logic;
	signal Sln_xferAck  : in  std_logic);
end package;

--------------------------------------------------------------------------------
library ieee;
use ieee.numeric_std.all;

package body OpbPak is
	procedure OPB_read(
		a                   :     std_logic_vector(0 to 31); 
		d                   :     std_logic_vector(0 to 31); 
		be                  :     std_logic_vector(0 to 3);
		--
		signal OPB_Clk      : in  std_logic;
		signal OPB_Rst      : in  std_logic;
		signal Interrupt    : in  std_logic;
		signal OPB_ABus     : out std_logic_vector(0 to 31);
		signal OPB_BE       : out std_logic_vector(0 to 3);
		signal OPB_DBus     : out std_logic_vector(0 to 31);
		signal OPB_RNW      : out std_logic;
		signal OPB_select   : out std_logic;
		signal OPB_seqAddr  : out std_logic;
		signal Sln_DBus     : in  std_logic_vector(0 to 31);
		signal Sln_errAck   : in  std_logic;
		signal Sln_retry    : in  std_logic;
		signal Sln_toutSup  : in  std_logic;
		signal Sln_xferAck  : in  std_logic) is
	begin
		
		wait until rising_edge(OPB_Clk); 
		wait for 5 ns;
		OPB_select<= '1';
		OPB_ABus  <= a;
		OPB_RNW   <= '1';
		OPB_BE    <= be;
		--OPB_DBus  <= d;
		
		wait until Sln_xferAck= '1';
		wait for 5 ns;
		
		--		assert(Sln_DBus = d) report "Sln_DBus mismatch" severity failure;
		
		assert(STD_MATCH(D, Sln_Dbus)) report "Sln_DBus mismatch" severity failure;
		
		wait until rising_edge(OPB_Clk);
		--		wait until rising_edge(OPB_Clk) and Sln_xferAck= '1';
		wait for 5 ns;
		
		OPB_select<= '0';
		OPB_ABus  <= (others=> 'X');
		OPB_RNW   <= 'X';
		OPB_BE    <= (others=> 'X');
		OPB_DBus  <= (others=> 'X');
	end procedure;
	--------------------------------------------------------
	procedure OPB_write(
		a                   :     std_logic_vector(0 to 31); 
		d                   :     std_logic_vector(0 to 31); 
		be                  :     std_logic_vector(0 to 3);
		--
		signal OPB_Clk      : in  std_logic;
		signal OPB_Rst      : in  std_logic;
		signal Interrupt    : in  std_logic;
		signal OPB_ABus     : out std_logic_vector(0 to 31);
		signal OPB_BE       : out std_logic_vector(0 to 3);
		signal OPB_DBus     : out std_logic_vector(0 to 31);
		signal OPB_RNW      : out std_logic;
		signal OPB_select   : out std_logic;
		signal OPB_seqAddr  : out std_logic;
		signal Sln_DBus     : in  std_logic_vector(0 to 31);
		signal Sln_errAck   : in  std_logic;
		signal Sln_retry    : in  std_logic;
		signal Sln_toutSup  : in  std_logic;
		signal Sln_xferAck  : in  std_logic) is
	begin
		
		wait until rising_edge(OPB_Clk); 
		wait for 5 ns;
		OPB_select<= '1';
		OPB_ABus  <= a;
		OPB_RNW   <= '0';
		OPB_BE    <= be;
		OPB_DBus  <= d;
		
		wait until rising_edge(OPB_Clk) and Sln_xferAck= '1';
		wait for 5 ns;
		
		OPB_select<= '0';
		OPB_ABus  <= (others=> 'X');
		OPB_RNW   <= 'X';
		OPB_BE    <= (others=> 'X');
		OPB_DBus  <= (others=> 'X');
	end procedure;
end package body;

--------------------------------------------------------------------------------
-- end of file
