/****************************************************************************
 *                               DFIOTrace.cc
 * Author: Matthew Ballance 
 * Desc:   Implements the core functionality of the DFIOTrace functionality.
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 ****************************************************************************/
#include "DFIOTrace.h"
#include "SdbSignal.h"

/************************************************************
 * DFIOTrace()
 ************************************************************/
DFIOTrace::DFIOTrace(
    Char        *trace_name,
    Uint32       rows,
    Uint32       msb,
    Uint32       lsb,
    Uint32       traceType) : 
        HashEntry(trace_name), name(trace_name)
{
    this->rows      = rows;
    this->msb       = msb;
    this->lsb       = lsb;
    this->traceType = traceType;
    this->len       = (msb < lsb)?(lsb-msb+1):(msb-lsb+1);
    d_indepTraceMax = false;
}

/************************************************************
 * ~DFIOTrace()
 ************************************************************/
DFIOTrace::~DFIOTrace()
{
    Uint32 idx=0;

    /**** Delete all clients of this DFIOTrace ****/
    while (idx < d_clients.length()) {
        Uint32     clen = d_clients.length();
        SdbSignal *sig  = d_clients.idx(idx);
       
        delete sig;

        if (d_clients.length() == clen) {
            fprintf(stderr, "ERROR: Problem removing a DFIOTrace client\n");
            idx++;
        }
    }
}

/************************************************************
 * AddClient()
 ************************************************************/
void DFIOTrace::AddClient(SdbSignal *signal)
{
    d_clients.append(signal);
}

/************************************************************
 * RemoveClient()
 ************************************************************/
void DFIOTrace::RemoveClient(SdbSignal *signal)
{
    d_clients.remove(signal);
}

/************************************************************
 * getTraceMaxTime()
 ************************************************************/
Uint32 DFIOTrace::getTraceMaxTime()
{
    if (d_indepTraceMax) {
        return d_traceTime;
    } else if (parent) {
        return parent->maxTime;
    } else {
        return 0;
    }
}

/************************************************************
 * base_setTime()
 ************************************************************/
Int32 DFIOTrace::base_setTime(Uint32    newTime)
{
    if (parent) {
        d_traceTime = newTime;
        parent->setTime(newTime);
    } else {
        return -1;
    }
}


/************************************************************
 * base_getValue()
 ************************************************************/
Vector<DFIOValChg> *DFIOTrace::base_getValue(
        Uint32          begin, 
        Uint32          end, 
        Uint32          flags)
{
    return new Vector<DFIOValChg>();
}


