/*****************************************************************************
 *                               HashEntry.cc
 * Author: Matthew Ballance
 * Desc:   Base class for a hash-table entry
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#include "HashEntry.h"
#include <string.h>

/**************************************************************
 * HashEntry()
 **************************************************************/
HashEntry::HashEntry(
    Char        *entryName
    )
{
    this->entryName = new char[strlen(entryName)+1];
    strcpy(this->entryName, entryName);
}

/**************************************************************
 * hash()
 * Computes a hash-value based on table size
 **************************************************************/
Uint32 HashEntry::hash(
    Uint32        tableSize
    )
{
    return HashEntry::hash(entryName, tableSize);
}

/**************************************************************
 * hash()
 **************************************************************/
Uint32 HashEntry::hash(const char *str, Uint32 tableSize)
{
    const char *p;
    char ch;
    Uint32 h=0, h2=0, pos=0, g;

    for(p=str; (*p != 0); p++)
    {
        ch=*p;
        h2<<=3;
        h2-=((unsigned int)ch+(pos++));         

        h=(h<<4)+ch;
        if((g=h&0xf0000000))
                {
                h=h^(g>>24);
                h=h^g;
                }
        }

    h^=h2;
    return(h%tableSize);
}

/**************************************************************
 * compare()
 * Compares this hash entry to the entry passed in
 **************************************************************/
Int32 HashEntry::compare(
    HashEntry    *e2
    )
{
    int ret;

    ret = strcmp(this->entryName, e2->entryName);
    return ret;
} 

/**************************************************************
 * compare
 **************************************************************/
Int32 HashEntry::compare(
        HashEntry     *e,
        const char    *key)
{
    return strcmp(e->entryName, key);
}




