/****************************************************************************
 *                                LogMgr.h
 *
 * Author: Matthew Ballance
 * Desc:   Manager for the logfile sources and destinations
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_LOG_MGR_H
#define INCLUDED_LOG_MGR_H
#include "vector.h"
#include "ivi_String.h"
#include "ObjWidgetBase.h"
#include "LogRegionType.h"
#include <tcl.h>

class LogRegionType;
class LogInstance;
class LogDestination;
class LogMgr : public ObjWidgetBase {
    public:
        LogMgr(Tcl_Interp *interp, Uint32 objc, Tcl_Obj *const objv[]);
        static int AddRegionType(LogRegionType *newRegionType);
        static int AddInstance(LogInstance *newInst);
        static int FindRegionType(const char *typeName, LogRegionType **region);

        virtual int InstCmd(Int32 objc, Tcl_Obj *const objv[]);

        enum DebugLevel {
            DebugLevel_Off  = 0,
            DebugLevel_Low  = 1,
            DebugLevel_Med  = 2,
            DebugLevel_High = 3
        };

        static LogMgr *GetLogMgr();
        static void LogMgr_Init(Tcl_Interp *, int , Tcl_Obj *const objv[]);

    private:
        Vector<LogRegionType>        *logRegions;
        Vector<LogInstance>          *logInstances;
        Vector<LogDestination>       *logDestinations;

        static LogMgr                *Globl_LogMgr;
};

#include "LogInstance.h"
#include "LogInstLevel.h"
#include "LogDestination.h"

#endif /* INCLUDED_LOG_MGR_H */

