/****************************************************************************
 *                          RemoteAppServer.cc
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "RemoteAppServer.h"
#include "RemoteAppSrvConnection.h"
#include <sys/types.h>

#ifndef __MINGW32__
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>

/********************************************************************
 * RemoteAppServer()
 ********************************************************************/
RemoteAppServer::RemoteAppServer(Tcl_Interp *interp)
{
    char *pval;
    Tcl_DString     sockName;

    Tcl_DStringInit(&sockName);

    d_interp = interp;

    d_channel = Tcl_OpenTcpServer(d_interp, 0, "localhost",
        &RemoteAppServer::AcceptProc, this);

   
    int ret;

    ret=Tcl_GetChannelOption(d_interp, d_channel, "-sockname", &sockName);

    if (ret != TCL_OK) {
        fprintf(stderr, "GetChannelOption error: %s\n",
            Tcl_GetStringResult(d_interp));
        return;
    }

    int           argc;
    const  char **argv;

    /*** Now, need to parse result for the port number ***/
    Tcl_SplitList(d_interp, Tcl_DStringValue(&sockName),
            &argc, &argv);

    if (argc >= 3) {
        d_port = strtoul(argv[2], 0, 0);
    } else {
        fprintf(stderr, "ERROR: Problem getting server port\n");
        return;
    }

    pval = (char *)malloc(strlen("IVI_SRV_PORT=")+16);
    sprintf(pval, "IVI_SRV_PORT=%d", d_port);
    putenv(pval);

    fprintf(stderr, "NOTE: Port is: %d\n", d_port);
    fflush(stderr);

    Tcl_DStringFree(&sockName);
}

/********************************************************************
 * Accept()
 ********************************************************************/
void RemoteAppServer::Accept(Tcl_Channel channel, char *hostname, int port)
{
    RemoteAppSrvConnection *conn;

    if (Tcl_SetChannelOption(d_interp, channel, "-blocking", "false") 
        != TCL_OK) {
        fprintf(stderr, "-blocking failed: %s\n", 
            Tcl_GetStringResult(d_interp));
        fflush(stderr);
    }

    if (Tcl_SetChannelOption(d_interp, channel, "-buffering", "none")!=TCL_OK)
    {
        fprintf(stderr, "-buffering failed: %s\n", 
            Tcl_GetStringResult(d_interp));
        fflush(stderr);
    }

    if (Tcl_SetChannelOption(d_interp, channel, "-encoding", "binary") 
        != TCL_OK) {
        fprintf(stderr, "-encoding failed: %s\n", 
            Tcl_GetStringResult(d_interp));
        fflush(stderr);
    }

    if (Tcl_SetChannelOption(d_interp, channel, 
                "-translation", "binary") != TCL_OK) {
        fprintf(stderr, "-translation failed: %s\n", 
            Tcl_GetStringResult(d_interp));
        fflush(stderr);
    }

    conn = new RemoteAppSrvConnection(d_interp, channel);
}

/********************************************************************
 * RemoteAppServer_Init()
 ********************************************************************/
extern "C" int RemoteAppServer_Init(Tcl_Interp *interp)
{
    RemoteAppServer *rsrv = new RemoteAppServer(interp);
    return TCL_OK;
}


