/****************************************************************************
 *                        RemoteAppTclCmdListener.h
 *
 * Author: Matthew Ballance
 * Desc:   Definition of a Tcl command-processing channel listener
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_REMOTE_APP_TCL_CMD_LISTENER_H
#define INCLUDED_REMOTE_APP_TCL_CMD_LISTENER_H
#include "RemoteAppConnectionListener.h"

class RemoteAppTclCmdResp;
class RemoteAppTclCmdListener : public RemoteAppConnectionListener {

    friend class RemoteAppTclCmdResp;

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * RemoteAppTclCmdListener()
         ************************************************************/
        RemoteAppTclCmdListener(Tcl_Interp *interp);

        /************************************************************
         * ~RemoteAppTclCmdListener()
         ************************************************************/
        virtual ~RemoteAppTclCmdListener();

        /************************************************************
         * getInterp()
         ************************************************************/
        inline Tcl_Interp *getInterp() const { return d_interp; }

        /************************************************************
         * Command()
         ************************************************************/
        int Command(Tcl_Interp *interp, Tcl_Obj *obj);
        
        /************************************************************
         * Command()
         ************************************************************/
        int Command(Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);

        /************************************************************
         * Command()
         ************************************************************/
        int Command(Tcl_Interp *interp, char *command);

        /************************************************************
         * Command()
         ************************************************************/
        int Command(Tcl_Interp *interp, int argc, char **argv);

        /************************************************************
         * Receive()
         ************************************************************/
        virtual void Receive(Uint32 subChanIdx, Uint32 len, Uchar *data);

        /************************************************************
         * Connect()
         ************************************************************/
        virtual void Connect(RemoteAppConnection *conn);


    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * CmdResp()
         ************************************************************/
        void CmdResp(Uint32 len, Uchar *data);

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        Uchar                 *d_respBuf;
        Uint32                 d_respBufLen;
        Uint32                 d_respBufMax;

        Int32                  d_resp;
        Tcl_Interp            *d_interp;
};

#endif /* INCLUDED_REMOTE_APP_TCL_CMD_LISTENER_H */
