/****************************************************************************
 *                             SimInfo.h
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_SIM_INFO_H
#define INCLUDED_SIM_INFO_H
#include "IviSim.h"
#include "ivi_String.h"
#include <tcl.h>

class SimInfo {
    public:
        SimInfo(Tcl_Interp *interp, Char *name, Char *desc, Char *fileSuffixes);

        virtual IviSim *newSim(Tcl_Interp *interp, int argc, char **argv);

        const String &getName(void) const { return simName; }
        const String &getDesc(void) const { return simDesc; }
        const String &getSuffixes(void) const { return fileSuffixes; }

        Tcl_Obj *getSuffixList() { return d_suffixList; }

    private:
        String        simName;
        String        simDesc;
        String        fileSuffixes;

        Tcl_Obj      *d_suffixList;

        Tcl_Interp   *d_interp;
};

#endif /* INCLUDED_SIM_INFO_H */



