/****************************************************************************
 *                              StimSeqInst.h
 *
 * Author: Matthew Ballance
 * Desc:   Describes an instance of a stimulus sequence. The instance walks
 *         the stimulus sequence and drives the values onto the specified
 *         signal...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_STIM_SEQ_INST_H
#define INCLUDED_STIM_SEQ_INST_H
#include "Stack.h"
#include "StimSeqLevel.h"
#include "vpi_user.h"

class StimulusSeq;
class StimulusMgr;

class StimSeqInst {

    public:
        StimSeqInst(vpiHandle vpiHndl, StimulusSeq *seqTempl);
       ~StimSeqInst();

    private:

        /**** sequence-application data ****/
        s_cb_data             cb_data;
        s_vpi_time            cb_time;
        vpiHandle             vpiHndl;
        /**** Count of the number of times this sequence has been
         **** played...
         ****/
        Uint32                repeatCnt;
        Uint32                d_sig_width;
        StimulusMgr          *mgr;

        enum OutModeType {
            ModeOutput,
            ModeDelay,
            ModeRepeatDelay,
            ModeSetupNext
        };
        OutModeType           outMode;
        Stack<StimSeqLevel>   levStack;

        static int SequenceCB(p_cb_data cb_data_p);
};

#endif /* INCLUDED_STIM_SEQ_INST_H */

