/****************************************************************************
 *                           StimSeqLevel.cc
 *
 * Author: Matthew Ballance
 * Desc:   Describes a level in a hierarchical sequence description
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "StimSeqLevel.h"

/********************************************************************
 * StimSeqLevel()
 ********************************************************************/
StimSeqLevel::StimSeqLevel(StimulusSeq *sequence)
{
    seq        = sequence;
    seq_idx    = 0;
    repeat_cnt = 0;
}

/********************************************************************
 * operator new
 ********************************************************************/
void *StimSeqLevel::operator new (size_t bytes)
{
    void *ret = 0;

    if (alloc_stack) {
        ret = (void *)alloc_stack;
        alloc_stack = alloc_stack->next;
    } else {
        ret = (void *)new char[sizeof(StimSeqLevel)];
    }

    return ret;
}

/********************************************************************
 * operator delete
 ********************************************************************/
void StimSeqLevel::operator delete (void *ptr)
{
    StimSeqLevel *seq = (StimSeqLevel *)ptr;

    seq->next = alloc_stack;
    alloc_stack = seq;
}

StimSeqLevel *StimSeqLevel::alloc_stack = 0;

