#****************************************************************************
#*                           base_class.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Implements an experimental base-class for namespace-based classes
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************
namespace eval BaseClass {
    namespace export constructor
}

#********************************************************************
#* method
#* Wrapper around 
#********************************************************************
proc BaseClass::method args {
    set method [lindex $args 0]

    set caller [lindex [info level 0] 0]
    upvar #0 [lindex $caller 0] this
    puts "this = $caller"

    set cmds [lindex [array get this methods] 1]
    if {[lsearch -exact $cmds $method] != -1} {
        eval ::$this(classname)::$method [lindex $caller 0] [lrange $args 1 end]
    } else {
        error "method $method doesn't exist"
    }
}

#****************************************************************************
#* constructor
#*
#* Creates a new instance of a class...
#****************************************************************************
proc BaseClass::constructor args {
    set classname [lindex $args 0]
    set classinst [lindex $args 1]


    uplevel #0 [list array set ${classinst} {init 1}]
    upvar #0 ${classinst} this

    set this(classname) ${classname}
    set this(classinst) ${classinst}

    set cmds [uplevel #0 [list info commands ${classname}::*]]
    foreach cmd $cmds {
        regsub "^::${classname}::" $cmd {} res
        puts "cmd = $res"
        lappend this(methods) $res
    }

    uplevel #0 [list proc ${classinst} args [info body BaseClass::method]]
}

#****************************************************************************
#* config_init
#****************************************************************************
proc BaseClass::config_init {path configspec} {
    upvar #0 $path data

    foreach config $configspec {
        set data([lindex $config 0]) [lindex $config 1]
    }
}

#****************************************************************************
#* cget
#****************************************************************************
proc BaseClass::cget {path opt} {
    upvar #0 $path data

    set varr [array get data $opt]

    if {$varr != ""} {
        return $data($opt)
    } else {
        error "unknown cget \"$opt\""
    }
}

#****************************************************************************
#* configure
#****************************************************************************
proc BaseClass::configure {path args} {
    upvar #0 $path data

    while {[llength $args] > 0} {
        set arg [lindex $args 0]
        set val [lindex $args 1]

        set varr [array get data $arg]
        
        if {$varr != ""} {
            set data($arg) $val
        } else {
            error "no conf entry \"$arg\""
        }
        set args [lrange $args 2 end]
    }
}

#****************************************************************************
#* subwidget
#****************************************************************************
proc BaseClass::subwidget {path sub} {
    upvar #0 $path data

    set var [array get data "w:$sub"]

    if {$var != ""} {
        return $data(w:$sub)
    } else {
        error "no sub-widget \"$sub\""
    }
}

