/****************************************************************************
 * GhdlRemoteSim.cc
 ****************************************************************************/
#include "GhdlRemoteSim.h"
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

/********************************************************************
 * GhdlRemoteSim()
 ********************************************************************/
GhdlRemoteSim::GhdlRemoteSim(Tcl_Interp *interp, int argc, char **argv)
    : IviRemoteSim(interp, argc, argv)
{
}

/********************************************************************
 * ~GhdlRemoteSim()
 ********************************************************************/
GhdlRemoteSim::~GhdlRemoteSim()
{
}

/********************************************************************
 * LoadDesign()
 ********************************************************************/
int GhdlRemoteSim::LoadDesign(char *design)
{
    char        *ivi_home = getenv("IVI_HOME");
    String       cmd;
    int          ret;

    if (design[0] == '/') {
        cmd =  design;
    } else {
        cmd =  "./";
        cmd += design;
    }

    cmd += " --vpi=";
    cmd += ivi_home;
    cmd += "/modules/ghdl_remote_sim/ghdl_remote.vpi";

    ret = StartSimulator(cmd.value());

    if (ret == 0) {
        return TCL_OK;
    } else {
        return TCL_ERROR;
    }
}


