/****************************************************************************
 *                        IviRemoteDesignDBSrv.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements the server (IVI) side interface to the remote DDB
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "IviRemoteDesignDBSrv.h"


/********************************************************************
 * IviRemoteDesignDBSrv()
 ********************************************************************/
IviRemoteDesignDBSrv::IviRemoteDesignDBSrv(
        RemoteAppTclCmdListener           *cmdChan,
        Tcl_Interp                        *interp,
        int                                argc,
        char                             **argv) : 
    DesignDB(interp, argc, argv), d_cmdChan(cmdChan), d_interp(interp)
{
}

/********************************************************************
 * InstCmd()
 ********************************************************************/
int IviRemoteDesignDBSrv::InstCmd(
        int                  argc,
        char               **argv)
{
    Tcl_Obj *list = Tcl_NewListObj(0, 0);
    int      ret;

    Tcl_ListObjAppendElement(d_interp, list, 
            Tcl_NewStringObj(instName.value(), -1));
    for (int i=0; i<argc; i++) {
        Tcl_ListObjAppendElement(d_interp, list, Tcl_NewStringObj(argv[i], -1));
    }

    Tcl_IncrRefCount(list);
    ret = d_cmdChan->Command(d_interp, list);
    Tcl_DecrRefCount(list);

    return ret;
}


