/****************************************************************************
 *                            IviRemoteProto.h
 *
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_IVI_REMOTE_PROTO_H
#define INCLUDED_IVI_REMOTE_PROTO_H

#define REMOTE_CMD_IDX    16
#define REMOTE_RESP_IDX   17
#define REMOTE_SDB_IDX    18

typedef enum {

  IVI_REMOTE_NULL = 0,

/********************************************************************
 * IVI_REMOTE_INIT
 ********************************************************************/
  IVI_REMOTE_INIT,

/********************************************************************
 * IVI_REMOTE_INST_NAME
 ********************************************************************/
  IVI_REMOTE_INST_NAME,

/********************************************************************
 * IVI_REMOTE_INST_NAME_RESP
 ********************************************************************/
  IVI_REMOTE_INST_NAME_RESP,

/********************************************************************
 * IVI_REMOTE_LOAD_DONE
 *
 * Returns the following information:
 * - Simulation resolution: (Int32)
 ********************************************************************/
  IVI_REMOTE_LOAD_DONE,

/********************************************************************
 * IVI_REMOTE_RUN
 *
 * Args:
 * - Uint32 run_time
 *
 *
 * Responses:
 * - 
 ********************************************************************/
  IVI_REMOTE_RUN,

/********************************************************************
 * IVI_REMOTE_STOP
 *
 * Args:
 * - Uint32 Interrupt
 *   - Indicates whether this stop was an interrupt
 *
 * - Uint64 SimTime {low, high}
 ********************************************************************/
  IVI_REMOTE_STOP,

/********************************************************************
 * IVI_REMOTE_CLOSE
 *
 * Args: none
 *
 * Sent by IVI to close down a remote simulator. The remote sim is
 * expected to respond with IVI_REMOTE_CLOSE_DONE
 ********************************************************************/
  IVI_REMOTE_CLOSE,

/********************************************************************
 * IVI_REMOTE_CLOSE_DONE
 *
 * Simulator response to close-down request.
 *
 * Simulator expects to receive IVI_REMOTE_CLOSE_EXIT before 
 * exiting..
 ********************************************************************/
  IVI_REMOTE_CLOSE_DONE,

/********************************************************************
 * IVI_REMOTE_CLOSE_EXIT
 *
 * Simultor expects IVI to send this after receiving 
 * IVI_REMOTE_CLOSE_DONE
 ********************************************************************/
  IVI_REMOTE_CLOSE_EXIT,

  IVI_REMOTE_LAST
} IviRemoteCmds;


/****************************************************************************
 * Commands for the SigDB
 ****************************************************************************/
typedef enum {

    /****************************************************************
     * IVI_REMOTE_SDB_ADD_SIGS
     *
     * Args:
     *     - signal-spec
     ****************************************************************/
    IVI_REMOTE_SDB_ADD_SIGS,

    /****************************************************************
     * IVI_REMOTE_SDB_ADD_DONE
     *
     * Command response to IVI_REMOTE_SDB_ADD_SIGS
     ****************************************************************/
    IVI_REMOTE_SDB_ADD_DONE,


    IVI_REMOTE_SDB_LAST
} IviRemoteSDBCmds;

#endif /* INCLUDED_IVI_REMOTE_PROTO_H */


