/****************************************************************************
 *                               ivi_opts.h
 * Author: Matthew Ballance
 * Desc:   This class describes the command-line options that ivi supports.
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 ****************************************************************************/
#include "ivi_String.h"
#include "vector.h"
#include "types.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

struct DoFile {
    public:
        DoFile(const char *handler, const char *file);

        String        d_handler;
        String        d_file;
};

struct ViewFile {
    public:
        ViewFile(const char *handler, const char *file);

        String        d_handler;
        String        d_file;
};

class IviOpts {

public:
    IviOpts(Uint32 argc, Char **argv);

    Vector<DoFile>        *doFiles;
    Vector<ViewFile>      *viewFiles;
    Vector<String>        *preDoFiles;
    Vector<String>        *modules;
    Vector<String>        *modulePath;
    String                *design;
    String                *logFile; 
    bool                   commandLine;
    bool                   console;
    bool                   versionCheck;
    bool                   needHelp;

    void printHelp();
};


