#****************************************************************************
#*                               SimCtrl.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Implements the sim-control widget found on the console and
#*         wave-window toolbars
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************

namespace eval SimCtrl {

}

#********************************************************************
#* SimCtrl
#********************************************************************
proc SimCtrl::SimCtrl {menu path args} {
    global CallbackTypes
    upvar #0 $menu data

    bind $menu <Destroy> "SimCtrl::Destroy $menu"

    $menu add_sep
    $menu add_button run -image run.gif \
        -command "SimCtrl::GuiRun $menu" -helptext "Run simulation"

#        -command "CmdWidget::run_cmd $cmd_window [list SimCmds::run forever]" \

    $menu add_button stop -image stop.gif \
        -command "SimCmds::stop" \
        -helptext "Stop simulation"

    $menu add_combo runlen -width 7
    set combo [$menu subwidget runlen]

    $combo configure -values [list forever 10] -command \
        [list puts "value = [$combo getvalue]"]
    $combo setvalue first

    bind $combo <Return> {puts "Enter binding triggered"}

    callback add $CallbackTypes(SIM_DESIGN_LOAD) null \
        [list SimCtrl::DesignLoadCB $menu]
    callback add $CallbackTypes(SIM_DESIGN_CLOSE) null \
        [list SimCtrl::DesignCloseCB $menu]

    set data(run_start_cb) ""
    set data(run_end_cb) ""

    #*** disable the controls initially
    DesignCloseCB $menu

    if {$SimCmds::d_designLoaded} {
        DesignLoadCB $menu
    }
}

#********************************************************************
#*
#********************************************************************
proc SimCtrl::Destroy {menu} {
    upvar #0 $menu data

    if {$data(run_start_cb) != ""} { 
        callback destroy $data(run_start_cb)
    }

    if {$data(run_end_cb) != ""} {
        callback destroy $data(run_end_cb)
    }
}

#********************************************************************
#* GuiRun
#********************************************************************
proc SimCtrl::GuiRun {menu} {
    global cmd_window

    set combo [$menu subwidget runlen]

    set value [$combo getvalue]

    set run_len "10"

    if {$value < 0} {
        #** user-supplied run-len
        set run_len [$combo cget -text]
    } else {
        set run_len [lindex [$combo cget -values] $value]
    }

    if {[catch \
        {CmdWidget::run_cmd $cmd_window [list SimCmds::run $run_len]} res]} {
        puts "ERROR: $res"
    }
}

#********************************************************************
#* BeginRunCB
#********************************************************************
proc SimCtrl::BeginRunCB args {
    set menu [lindex $args 0]

    [$menu subwidget run] configure -state disabled
    [$menu subwidget stop] configure -state normal
}

#********************************************************************
#* EndRunCB
#********************************************************************
proc SimCtrl::EndRunCB args {
    set menu [lindex $args 0]

    [$menu subwidget run] configure -state normal
    [$menu subwidget stop] configure -state disabled
}

#********************************************************************
#* DesignLoadCB
#********************************************************************
proc SimCtrl::DesignLoadCB {menu args} {
    global CallbackTypes
    upvar #0 $menu data

    [$menu subwidget run] configure -state normal
    [$menu subwidget runlen] configure -state normal

    set sim $SimCmds::d_sim
    set res [$sim resolution]
    set res $SimCmds::d_simResolution

    #*** Add run/stop callbacks
    set data(run_start_cb) [callback add $CallbackTypes(SIM_RUNSTEP_START) \
        $sim [list SimCtrl::BeginRunCB $menu]]
    set data(run_end_cb) [callback add $CallbackTypes(SIM_RUNSTEP_END) $sim \
        [list SimCtrl::EndRunCB $menu]]

    set lst "forever"
    foreach u {1 10 100} {
        lappend lst "${u}$res"
    }

    switch $res {
        ps {
            #*** Add ns and us timing
            foreach s {ns us} {
                foreach u {1 10 100} {
                    lappend lst "${u}$s"
                }
            }
        }

        ns {
            #*** Add ns and us timing
            foreach s {us} {
                foreach u {1 10 100} {
                    lappend lst "${u}$s"
                }
            }
        }

        default {
        }
    }

    [$menu subwidget runlen] configure -values $lst
    [$menu subwidget runlen] setvalue first
}

#********************************************************************
#* DesignCloseCB
#********************************************************************
proc SimCtrl::DesignCloseCB {menu args} {
    foreach button {run stop} {
        set b [$menu subwidget $button]
        $b configure -state disabled
    }
    [$menu subwidget runlen] configure -state disabled
}

