/****************************************************************************
 *                           ShmDFIOTrace.h
 *
 * Author: Matthew Ballance
 * Desc:   Data structures to represent traces in the SHM file and to IVI
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_SHM_DFIO_TRACE_H
#define INCLUDED_SHM_DFIO_TRACE_H
#include "DFIOTrace.h"
#include "ShmDFIOHeader.h"
#include "ShmDFIOChgBlk.h"
#include "vector.h"

typedef struct ShmDFIOTraceDesc {
    Uint32         rows;
    Uint32         msb;
    Uint32         lsb;
    Uint32         traceType;
    Uint32         numChgBlks;
    ShmDFIOPtr     chgBlkList;
    ShmDFIOPtr     nextTrace;
    char           name[1];
} ShmDFIOTraceDesc;


class ShmDFIO;
class ShmDFIOTrace : public DFIOTrace {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * ShmDFIOTrace()
         *
         * Constructor for a reading trace
         ************************************************************/
        ShmDFIOTrace(
                ShmDFIO             *dfio,
                ShmDFIOTraceDesc    *desc);

        /************************************************************
         * ShmDFIOTrace()
         *
         * Constructor for a write/read trace
         ************************************************************/
        ShmDFIOTrace(
                ShmDFIO       *file,
                Char          *name,
                Uint32         rows,
                Uint32         msb,
                Uint32         lsb,
                Uint32         traceType);

        /************************************************************
         * ~ShmDFIOTrace()
         ************************************************************/
        virtual ~ShmDFIOTrace();

        /************************************************************
         * setValueBitStr()
         ************************************************************/
        virtual Int32 setValueBitStr(Uint32 row, Char *bitStr);

        /************************************************************
         * setValueABVal8()
         ************************************************************/
        virtual Int32 setValueABVal8(Uint32 row, DFIOVal8 *value);

        /************************************************************
         * setValueABVal32()
         ************************************************************/
        virtual Int32 setValueABVal32(Uint32 row, DFIOVal32 *value);

        /************************************************************
         * getValue()
         ************************************************************/
        virtual Vector<DFIOValChg> *getValue(
                Uint32 begin, Uint32 end, Uint32 flags);

        /************************************************************
         * clearTrace()
         ************************************************************/
        virtual void clearTrace();

        /************************************************************
         * getTraceDescPtr()
         ************************************************************/
        inline ShmDFIOPtr getTraceDescPtr() { return d_traceDesc; }

        /************************************************************
         * Update()
         *
         * Returns 1 if trace data changed...
         ************************************************************/
        int Update();

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:
        ShmDFIOChgBlk *AllocChgBlock();

        /************************************************************
         * findBlock()
         ************************************************************/
        Uint32 findBlock(Uint32 reqTime);


    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        Vector<ShmDFIOChgBlk>    d_valChgBlocks;
        ShmDFIOChgBlk           *d_currValChgBlock;

        ShmDFIOPtr               d_traceDesc;

        Uint32                   d_numChgBlks;

        ShmDFIO                 *d_dfio;
        bool                     d_initial;

        Uint32                   d_traceId;

        static Uint32            d_traceCount;
};

#endif /* INCLUDED_SHM_DFIO_TRACE_H */

