/****************************************************************************
 *                             StubInfo.cc
 * Author: Matthew Ballance
 * Desc:   Describes the Stub DFIO
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "StubInfo.h"
#include "DFIOMgr.h"
#include "StubRw.h"
#include "StubFilter.h"
#include <tcl.h>

#define STUB_DESC "The Stub DFIO is an in-memory DFIO. No file is used " \
                  "to store the data."

/***********************************************************
 * StubInfo()
 ***********************************************************/
StubInfo::StubInfo(Char *name, Char *desc) : 
    DFIOInfo(name, desc)
{
    /**** Empty ****/
}


/***********************************************************
 * newDFIO()
 ***********************************************************/
DFIO *StubInfo::newDFIO(Tcl_Interp *interp, int argc, char **argv)
{
    StubRw   *sdfio = new StubRw(interp, argc, argv);

    return sdfio;
}


/***********************************************************
 * newDFIOTrace()
 ***********************************************************/
DFIOTrace *StubInfo::newDFIOTrace(
                Char        *name,
                Uint32       rows,
                Uint32       msb,
                Uint32       lsb,
                Uint32       traceType)
{
    return new StubTrace(name, rows, msb, lsb, traceType);
}


/***********************************************************
 * Stubdfio_Init()
 * Registers the StubDFIO with the environment...
 ***********************************************************/
extern "C" int Stub_dfio_Init(Tcl_Interp *interp)
{
    StubInfo      *stubInfo;
    StubFilter    *sf;

    if (Tcl_InitStubs(interp, "8.1", 0) == NULL) {
        return TCL_ERROR;
    }
    Tcl_PkgProvide(interp, "stub_dfio", "1.0");

    stubInfo = new StubInfo("StubDFIO", STUB_DESC);

    DFIOMgr_RegisterDFIO(stubInfo);

    sf       = new StubFilter(interp);
    DFIOMgr_RegisterDFIOFilter(sf);

    return TCL_OK;
}

extern "C" int Stub_dfio_SafeInit(Tcl_Interp *interp)
{
    return Stub_dfio_Init(interp);
}

