/****************************************************************************
 *                          VVPRemoteSimPlugin.h
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_VVP_REMOTE_SIM_PLUGIN_H
#define INCLUDED_VVP_REMOTE_SIM_PLUGIN_H
#include "IviRemoteSimPlugin.h"

class VVPRemoteIviSim;
class VVPRemoteSimPlugin : public IviRemoteSimPlugin {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * VVPRemoteSimPlugin()
         */
        /**
         ************************************************************/
        VVPRemoteSimPlugin(Tcl_Interp *interp);

        /************************************************************
         * ~VVPRemoteSimPlugin()
         */
        /**
         ************************************************************/
        virtual ~VVPRemoteSimPlugin();

        /************************************************************
         * BeginRun()
         ************************************************************/
        virtual int BeginRun(Uint32 runLen);

    /****************************************************************
     * Protected Methods
     ****************************************************************/
    protected:

        /************************************************************
         * ConstructSim()
         */
        /** Expected to construct an IviSim object of the type 
         *  used by the remote portion of this simulator
         ************************************************************/
        virtual IviSim *ConstructSim();

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * TimeCB
         */
        /** 
         ************************************************************/
        static int TimeCB(p_cb_data cb_data) { 
            ((VVPRemoteSimPlugin *)cb_data->user_data)->TimeCB(cb_data, 0);
            return 0;
        }
        void TimeCB(p_cb_data cb_data, int null);

        /************************************************************
         * EndOfSimCB
         */
        /**
         * Called when simulation ends
         ************************************************************/
        static int EndOfSimCB(p_cb_data cb_data) {
            ((VVPRemoteSimPlugin *)cb_data->user_data)->EndOfSimCB();
            return 0;
        }
        void EndOfSimCB();

        /************************************************************
         * EndOfCompileCB()
         */
        /** 
         ************************************************************/
        static int EndOfCompileCB(p_cb_data cb_data) {
            ((VVPRemoteSimPlugin *)cb_data->user_data)->EndOfCompileCB();
            return 0;
        }
        void EndOfCompileCB();

        /************************************************************
         * SetupVpiCBs()
         */
        /** 
         ************************************************************/
        void SetupVpiCBs();

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

        VVPRemoteIviSim           *d_sim;
        s_cb_data                  d_cbdata;
        s_vpi_time                 d_time_s;
};

#endif /* INCLUDED_VVP_REMOTE_SIM_PLUGIN_H */
