/**********************************************************************/
/* ALERTE.C   : Gestion de boites d'alerte a boutons multiples        */
/*            : Action of the boxes of the Alert to buttons multiple  */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include "jered.h"

extern int resizewin;

#define NOERROR         0x0000
#define ERROR           0x7fff
#define OKBUTTON        0x0f00
#define CANCELBUTTON    0x0f01

#define BUTTONS_SEPARATOR       '|'

typedef struct _BUTTON *        PTBUTTON;
typedef struct _ALERTE *        PTALERTE;

typedef struct _BUTTON
{
        int xr; /* colonne relative */
                /* column relative */
        int yr; /* ligne relative */
                /* row relative */
        char *text;     /* message du bouton */
                        /* message of the button */
        PTBUTTON bsuiv; /* pointeur sur bouton suivant */
                        /* pointer to button next */
        PTBUTTON bprec; /* pointeur sur bouton precedent */
                        /* pointer to button previous */
} BUTTON;

typedef struct _ALERTE
{
        int x;                  /* colonne */
                                /* column */
        int y;                  /* ligne */
                                /* row */
        int l;                  /* largeur */
                                /* width */
        int h;                  /* hauteur */
                                /* height  */
        int nbuttons;           /* nombre de boutons de cette boite d'alerte */
                                /* number of the button of this box of alert */
        int firsttime;          /* indique le premier appel a dessine_alerte() */
                                /* indicate the first call to dessine_alert() */
        char *title;            /* titre */
                                /* title */
        chtype *sauve;          /* pour sauver le fond de l'ecran sous la boite d'alerte */
                                /* for saving the bottom of the screen  below the box of the alert */
        chtype *video;          /* buffer pour construire la boite d'alerte */
                                /* buffer for the construction of the box of the alert */
        PTBUTTON bselected;     /* indique le bouton selectionne */
                                /* indicator of the button selected */
        PTBUTTON bfirst;        /* pointeur vers premier bouton */
                                /* pointer towards the first button */
} ALERTE;

int alerte(int, char *, char *);  /* prototype definitions */
static int compte_boutons(char *);
static int cree_boutons(PTALERTE, char *, char *);
static int lire_alerte(PTALERTE);
chtype *carac_attrib(unsigned char *, chtype *, chtype);
static void dessine_bouton(PTALERTE, PTBUTTON);
static void detruit_alerte(PTALERTE);
static void detruit_boutons(PTALERTE);
static PTALERTE cree_alerte(char *, char *);
static PTBUTTON ajoute_bouton(PTALERTE);
static PTBUTTON dessine_alerte(PTALERTE, PTBUTTON, PTBUTTON);
/**********************************************************************/
static int compte_boutons(char *chbuttons) /* counter of the button */
/* Purpose:
THIS FUNCTION COMPUTES THE NUMBER OF DIFFERENT BUTTONS IN THE ALERT
BOX ACCORDING TO BUTTONS'S SEPARATOR ('|') FOUND IN THE STRING chbuttons.
FOR EXAMPLE IF YOUR STRING IS "YES|NO" THEN THIS FUNCTION WILL RETURN 2.
..........................      */
{
        int nbre;       /* compteur de boutons */
                        /* counter of the button */

        if (*chbuttons)
        {
                nbre = 1;
                while (*chbuttons)
                {
                        if (*chbuttons++ == BUTTONS_SEPARATOR)
                                nbre++;
                }
        }
        else
                nbre = 0;

        return(nbre);
}
/**********************************************************************/
static int cree_boutons(PTALERTE palerte, char *title, char *buttons)
/* Purpose:
THIS FUNCTION CREATES A CIRCULAR LIST OF ALL THE BUTTONS OF THE ALERT
BOX, THEN IT COMPUTES SCREEN COORDINATES TO CENTER THE ALERT BOX ON THE
SCREEN.
 ..........................      */
{
        int retcode;            /* code de retour */
        int i;                  /* compteur */
        int lg;                 /* longueur courante d'un bouton */
        int lgmax;              /* longueur maxi des boutons */
        int xr;                 /* abscisse relative bouton courant */
        int yr;                 /* ordonnee relative bouton courant */
        PTBUTTON b;             /* pointeur de bouton */
        char *ptaff;            /* pointeur sur texte a afficher */
        char *ptext;            /* pointeur sur l'adresse allouee pour texte du bouton */
        char *ptb;              /* pointeur sur la chaine des boutons */
        char *oldptb;           /* sauvegarde du pointeur sur la chaine des boutons */
        char txtbutt[80];       /* copie du texte des boutons */
        int lgtit;              /* longueur du titre */
        int lgbut;              /* longueur des boutons */
        int lgbox = 0;          /* largeur de la boite */

        retcode = NOERROR;      /* par defaut pas d'erreur */

        strcpy(txtbutt, buttons);

                /* calcule le texte de bouton le plus long */
        oldptb = ptb = txtbutt; /* pointe sur les messages des boutons */
        lgmax = 0;
        while (*ptb)
        {
                if (*ptb == BUTTONS_SEPARATOR)
                {
                        lg = (int)(ptb - oldptb);
                        if (lgmax < lg)
                                lgmax = lg;
                        oldptb = ++ptb;
                }
                else
                        ptb++;
        }
        lg = (int)(ptb - oldptb);
        if (lgmax < lg)
                lgmax = lg;

        lgmax += 2;     /* + un espace de chaque cote = lg maxi texte d'1 bouton */
        /* lgmax++; */        /* 1 espace de plus a droite */

        lgtit = strlen(title) + 2;      /* longueur du titre + 2 espaces */
        palerte->nbuttons = compte_boutons(txtbutt);
        if (palerte->nbuttons)
        {
                lgbut = palerte->nbuttons * (lgmax + 4) + 2;

                lgbox = max((lgtit + 2), (lgbut + 2));

                xr = 3;                         /* coordonnees du premier bouton */
                if (lgbut < lgtit)
                        xr += ((lgtit - lgbut) / 2);

                yr = 3;                         /* relativement a la boite */

                ptb = txtbutt;                  /* pointe sur les messages des boutons */

                for (i = 0; (retcode != ERROR) && (i < palerte->nbuttons); i++)
                {
                                /* ajoute un bouton dans la boite d'alerte */
                        b = ajoute_bouton(palerte);
                        if (b == NULL)  /* impossible d'allouer un bouton de plus */
                                retcode = ERROR;
                        else
                        {
                                        /* si on arrive au dernier bouton, alors */
                                        /* on met a jour les pointeurs pour fermer */
                                        /* le cercle entre tous les boutons */
                                if (i == (palerte->nbuttons - 1))
                                {
                                        b->bsuiv = palerte->bfirst;
                                        palerte->bfirst->bprec = b;
                                }

                                        /* calcule la chaine a associer au bouton courant */
                                oldptb = ptb;
                                while (*ptb && (*ptb != BUTTONS_SEPARATOR))
                                        ptb++;

                                        /* si on est sur le separateur alors on pointe sur message suivant */
                                        /* apres avoir indique la fin du message courant */
                                if (*ptb)
                                        *ptb++ = '\0';

                                        /* alloue une chaine de taille suffisante pour le message courant */
                                        /* et on le centre sur la longueur maximale */
                                ptext = (char *)malloc(lgmax + 2);
                                if (ptext != NULL)
                                {
                                        memset(ptext, ' ', lgmax);
                                        *(ptext + lgmax) = '\0';
                                        lg = strlen(oldptb);

                                        /* changement ici */
                                        ptaff = ptext + (lgmax / 2) - (lg / 2);
                                        /*if (! (lgmax & 1))
                                                ptaff--; */
                                        memcpy(ptaff, oldptb, lg);

                                        b->text = ptext;

                                                /* met a jour les coordonnees */
                                        b->xr = xr;
                                        b->yr = yr;
                                        xr += lgmax + 4;        /* 2 / cadre et 2 espaces */
                                }
                                else
                                        retcode = ERROR;
                        }
                }
        }
        else
                retcode = ERROR;

        if (retcode != ERROR)
        {
                palerte->l = lgbox;
                palerte->h = 7;

                palerte->y = ((JEREDLINES - 1) / 2) - (palerte->h / 2);
                if (palerte->y < 0)
                        palerte->y = 0;

                palerte->x = ((JEREDCOLS / 2) - (palerte->l + (palerte->l & 1)) / 2) + 1;
                if (palerte->x < 0)
                        palerte->x = 0;

                ptext = (char *)malloc(lgbox + 2);
                if (ptext != NULL)
                {
                        lgbox -= 2;     /* largeur titre + espaces */
                        memset(ptext, ' ', lgbox);
                        *(ptext + lgbox) = '\0';
                        memcpy(ptext + ((lgbox - (lgtit - 2)) >> 1), title, (lgtit - 2));

                        palerte->title = ptext;
                }
                else
                        retcode = ERROR;
        }
        return(retcode);
}
/**********************************************************************/
static PTBUTTON ajoute_bouton(PTALERTE palerte)
/* Purpose:
THIS FUNCTION IS CALLED BY THE PREVIOUS FUNCTION. ITS PURPOSE IS TO
SET LINKS BETWEEN BUTTONS: FOR EACH BUTTON THERE IS A POINTER TO THE
PREVIOUS BUTTON AND A POINTER TO THE NEXT BUTTON. (AJOUTE <==> ADD)
 ..........................      */
{
        PTBUTTON b;     /* pointeur sur dernier bouton ajoute */
        PTBUTTON pb;    /* pointeur sur nouveau bouton */

        pb = (PTBUTTON)malloc(sizeof(BUTTON));

                /* si l'allocation a reussi, on initialise la zone */
        if (pb != NULL)
        {
                memset(pb, 0x0000, sizeof(BUTTON));

                        /* recherche ou inserer */
                for (b = palerte->bfirst; (b != NULL) && (b->bsuiv != NULL); b = b->bsuiv) ;

                /* si on est sorti avec b = NULL, pas deja un bouton dans la boite */
                if (b == NULL)
                {
                        palerte->bfirst = pb;
                }
                else
                {
                        b->bsuiv = pb;

                                /* positionne le pointeur vers le bouton precedent */
                        b->bsuiv->bprec = b;
                }
        }
        return (pb);
}
/**********************************************************************/
static void detruit_boutons(PTALERTE palerte)
/* Purpose:
THIS FUNCTION FREES ALL THE MEMORY ALLOCATED FOR THE CIRCULAR LIST OF
BUTTONS, FREEING ALL MEMORY ALLOCATED FOR EACH BUTTON.
 ..........................      */
{
        PTBUTTON b;     /* pointeur sur bouton suivant */
        PTBUTTON oldb;  /* pointeur sur bouton courant */

        b = palerte->bfirst;
        do
        {
                oldb = b;       /* sauve pointeur bouton courant */
                b = b->bsuiv;   /* pointe sur le suivant */

                if (oldb->text != NULL)
                        free(oldb->text);       /* libere texte du bouton */

                free(oldb);             /* libere bouton */
        }
        while (b != palerte->bfirst);
}
/**********************************************************************/
static PTALERTE cree_alerte(char *title, char *buttons)
/* Purpose:
THIS FUNCTION ALLOCATES MEMORY FOR A STRUCT _ALERTE, THEN CALLS THE
FUNCTION TO CREATE THE CIRCULAR LIST OF BUTTONS.
 ..........................      */
{
        PTALERTE palerte;        /* pointeur sur la boite d'alerte creee */

        if ((title == NULL) || (buttons == NULL) ||
            (! *title) || (! *buttons))
        {
                palerte = NULL;  /* erreur dans les parametres d'appel */
        }
        else
        {
                palerte = (PTALERTE)malloc(sizeof(ALERTE));
                if (palerte != NULL)
                {
                        memset(palerte, 0x0000, sizeof(ALERTE));
                        if (cree_boutons(palerte, title, buttons) == ERROR)
                        {
                                free(palerte);
                                palerte = NULL;
                        }
                        else
                                palerte->firsttime = 1;
                }
        }
        return(palerte);
}
/**********************************************************************/
static void detruit_alerte(PTALERTE palerte)
/* Purpose:
THIS FUNCTION FREES ALL THE MEMORY ALLOCATED BY ITS COMPONENTS AND
RESTORES THE ORIGINAL SCREEN APPEARANCE (WHAT WAS ON THE SCREEN BEFORE THE
ALERT BOX WAS DISPLAYED).
 ..........................      */
{
        /* libere memoire allouee */
        if (palerte != NULL)
        {

                if (palerte->video != NULL)
                        free(palerte->video);

                if (palerte->sauve != NULL)
                {
                        /* replace l'ecran comme avant l'alerte */
                        put_txt(palerte->x, palerte->y, palerte->x + palerte->l + 1, palerte->y + palerte->h, palerte->sauve);

                        /* libere memoire de la copie de l'ecran */
                        free(palerte->sauve);
                }
                if (palerte->title != NULL)
                        free(palerte->title);

                detruit_boutons(palerte);

                free(palerte);
        }
}
/**********************************************************************/
chtype *carac_attrib(register unsigned char *txt, \
  register chtype *mem, chtype color)
/* Purpose:
THIS FUNCTION IS USED TO FILL A BUFFER OF WHAT WILL BE PUT ON THE SCREEN
ACCORDING TO THE SOURCE TEXT STRING, THE DESTINATION MEMORY BUFFER AND THE
COM-BINATION OF ATTRIBUTES WHICH WILL BE ORed WITH EACH CHARACTER OF THIS
STRING.
 ..........................      */
{
        if (txt != NULL)
        {
                while (*txt)
                {
                        *mem++ = (chtype)((chtype)*txt++ | color);
                }
        }
        return(mem);
}
/**********************************************************************/
static void dessine_bouton(PTALERTE palerte, PTBUTTON bouton)
/* Purpose:
THIS FUNCTION DRAWS A BUTTON INTO THE MEMORY, PREPARING THE BUFFER TO
BE OUTPUTTED ON THE SCREEN.
 ..........................      */
{
        static chtype cadrage[20]; /* caracteres formant le cadre */
        static int first = 1;   /* premier passage */
        register chtype *ptw;   /* pointeur vers image du bouton */
        register chtype *ptc;
        chtype *ptl;            /* pointeur vers debut de chaque bouton */
        chtype coulx;           /* pour couleur du texte des boutons */
        chtype coulf;           /* couleur du fond de la boite */
        int i;                  /* compteur */
        int lg;                 /* longueur */
        chtype cb;              /* carcatere de cadrage */


        /* premier passage alors initialise cadrage */
        if (first)
        {
                ptc = cadrage;
                *ptc++ = hmd();
                *ptc++ = hgd();
                *ptc++ = hdd();
                *ptc++ = mgd();
                *ptc++ = bgd();
                *ptc++ = bdd();
                *ptc++ = hm();
                *ptc++ = hg();
                *ptc++ = hd();
                *ptc++ = mg();
                *ptc++ = bg();
                *ptc++ = bd();
                *ptc = (chtype)'\0';
                first = 0;
        }

        ptl = ptw = (chtype *)palerte->video + bouton->xr + (palerte->l * bouton->yr);

        coulf = couleur[COULEUR_ALERTE1];
        if (bouton == palerte->bselected)
        {
                ptc = cadrage;          /* cadre double */
                coulx = couleur[COULEUR_ALERTE2];      /* couleur du texte du bouton selectionne */
        }
        else
        {
                ptc = cadrage + 6;      /* cadre simple */
                coulx = couleur[COULEUR_ALERTE1];      /* couleur du texte des autres boutons */
        }

        cb = *ptc;

        *ptw++ = (*++ptc | coulf);

        lg = strlen(bouton->text);
        for (i = 0; i < lg; i++)
                *ptw++ = (cb | coulf);

        *ptw++ = (*++ptc | coulf);

        ptl = ptw = ptl + palerte->l;

        *ptw++ = (*++ptc | coulf);

        ptw = carac_attrib((unsigned char *)bouton->text, ptw, coulx);

        /* changement ici */
        /* *(ptw - 1) = (chtype)((chtype)' ' | coulf); */

        *ptw++ = (*ptc | coulf);

        ptw = ptl + palerte->l;

        *ptw++ = (*++ptc | coulf);

        for (i = 0; i < lg; i++)
                *ptw++ = (cb | coulf);

        *ptw++ = (*++ptc | coulf);
}
/**********************************************************************/
static PTBUTTON dessine_alerte(PTALERTE palerte, PTBUTTON newbutton, \
 PTBUTTON oldbutton)
/* Purpose:
THIS FUNCTION DOES THE SAME THING AS THE PREVIOUS FUNCTION BUT FOR THE
WHOLE ALERT BOX, DRAWING EACH BUTTON IN SELECTED OR IN NORMAL MODE
ACCORDING TO WHICH BUTTON IS CURRENTLY SELECTED, THEN THE ALERT BOX MEMORY
BUFFER IS OUTPUTTED ON THE SCREEN BY THE FUNCTION put_txt().
 ..........................      */
{
        int sizelig;            /* taille d'une ligne de la boite d'alerte */
        int sizemem;            /* taille de la memoire a allouer pour la boite */
        int j;                  /* compteur */
        chtype *memsauve;       /* pour sauver l'ecran */
        chtype *memvideo;       /* pour construire boite */
        unsigned char space[80];  /* pour centre de la boite */
        PTBUTTON b;             /* pointeur sur les boutons */
        chtype coulf;           /* couleur du fond de la boite */
        register chtype *ptw;    /* pointeur sur buffer de construction de la boite */
        int i;                  /* compteur */
        int lg;                 /* longueur */
        chtype cb;              /* pour cadre */
        chtype cm;              /* pour montant */

        coulf = couleur[COULEUR_ALERTE1];
        if (palerte->firsttime)
        {
                palerte->firsttime = 0;

                        /* calcul de la taille necessaire */
                sizelig = ((palerte->l + 2) * sizeof(chtype));
                sizemem = (sizelig + 2) * (palerte->h + 1);

                        /* allocation de la memoire pour sauver l'ecran */
                memsauve = (chtype *)malloc(sizemem + 2);
                if (memsauve == NULL)
                        return(NULL);  /* pas assez de memoire */

                        /* allocation de la memoire pour construire le formulaire */
                memvideo = (chtype *)malloc(sizemem + 2);
                if (memvideo == NULL)
                {
                        free(memsauve); /* libere memoire allouee sans erreur */
                        return(NULL);   /* pas assez de memoire */
                }

                        /* met a jour les pointeurs dans la boite */
                palerte->sauve = memsauve;
                palerte->video = memvideo;

                        /* sauve l'ecran avant l'ouverture de l'alerte */
                get_txt(palerte->x, palerte->y, palerte->x + palerte->l + 1, palerte->y + palerte->h, palerte->sauve);

                memset(space, ' ', 78);
                space[78] = '\0';
                space[palerte->l - 2] = '\0';

                cb = hmd();
                lg = palerte->l - 2;

                cm = mgd();

                ptw = memvideo;
                for (j = 0; j < palerte->h; j++)
                {
                        switch (j)
                        {
                                case 0:
                                case 2:
                                case 6:
                                        if (j == 0)
                                        {
                                                *ptw++ = (hgd() | coulf);
                                        }
                                        else if (j == 2)
                                        {
                                                *ptw++ = (gtd() | coulf);
                                        }
                                        else if (j == 6)
                                        {
                                                *ptw++ = (bgd() | coulf);
                                        }

                                        for (i = 0; i < lg; i++)
                                                *ptw++ = (cb | coulf);

                                        if (j == 0)
                                        {
                                                *ptw++ = (hdd() | coulf);
                                        }
                                        else if (j == 2)
                                        {
                                                *ptw++ = (dtd() | coulf);
                                        }
                                        else if (j == 6)
                                        {
                                                *ptw++ = (bdd() | coulf);
                                        }

                                        break;

                                case 1:
                                        *ptw++ = (cm | coulf);
                                        ptw = carac_attrib((unsigned char *)palerte->title, ptw, coulf);
                                        *ptw++ = (cm | coulf);

                                        break;

                                default:
                                        *ptw++ = (cm | coulf);
                                        ptw = carac_attrib(space, ptw, coulf);
                                        *ptw++ = (cm | coulf);

                                        break;
                        }
                }

                        /* on dessine chacun des boutons de la boite pour le premier passage */
                b = palerte->bfirst;
                do
                {
                        dessine_bouton(palerte, b);
                        b = b->bsuiv;
                }
                while (b != palerte->bfirst);

                        /* affiche la boite d'alerte */
                put_txt(palerte->x, palerte->y, palerte->x + palerte->l - 1, palerte->y + palerte->h - 1, palerte->video);
        }

                /* on redessine maintenant l'ancien bouton et le nouveau */
                /* si les deux boutons sont differents alors reaffichage */
                /* sinon ca vient d'etre fait plus haut */
        if (oldbutton != newbutton)
        {
                palerte->bselected = newbutton;

                dessine_bouton(palerte, oldbutton);
                dessine_bouton(palerte, newbutton);

                put_txt(palerte->x, palerte->y + palerte->bfirst->yr,
                        palerte->x + palerte->l - 1, palerte->y + palerte->bfirst->yr + 2,
                        palerte->video + (palerte->l * palerte->bfirst->yr));
        }
        return(newbutton);
}
/**********************************************************************/
static int lire_alerte(PTALERTE palerte)
/* Purpose:
THIS FUNCTION FIRST DRAWS THE ALERT BOX, THEN READ KEYS FROM KEYBOARD
AND ACTS ACCORDING TO WHAT IS TYPED. FOR EXAMPLE IF YOU TYPED LEFT ARROW
THEN THE CURRENT BUTTON IS REDRAWN IN NORMAL MODE AND THE PREVIOUS BUTTON
IS RE-DRAWN IN SELECTED MODE.
 ..........................      */
{
        int quitte;     /* indique si on quitte la boucle */
        int retcode;    /* code de retour */
        int touche;     /* touche appuyee */
        PTBUTTON b;     /* pointeur sur les boutons */

        retcode = ERROR;

        dessine_alerte(palerte, palerte->bselected, palerte->bselected);

        quitte = 0;
        while (! quitte)
        {
                touche = fread_key();   /* flush clavier avant lecture */
                switch (touche)
                {
                        case KEY_ESCAPE:
                        case Ctrl_G:
                                retcode = CANCELBUTTON;
                                quitte = 1;
                                break;

                        case KEY_RETURN:
                        case KEY_LINEFEED:
                                for (retcode = 1, b = palerte->bfirst; b != palerte->bselected; retcode++, b = b->bsuiv);
                                quitte = 1;
                                break;

                        case KEY_RIGHT:
                        case KEY_ESPACE:
                        case KEY_TAB:
                                if (dessine_alerte(palerte, palerte->bselected->bsuiv, palerte->bselected) == NULL)
                                {
                                        retcode = ERROR;
                                        quitte = 1;
                                }
                                break;

                        case KEY_LEFT:
                        case Shift_TAB:
                        case KEY_BTAB:
                                if (dessine_alerte(palerte, palerte->bselected->bprec, palerte->bselected) == NULL)
                                {
                                        retcode = ERROR;
                                        quitte = 1;
                                }
                                break;

                        default:
                                break;
                }
        }
        return(retcode);
}
/**********************************************************************/
int alerte(int selected, char *title, char *buttons)
/* Purpose:
THIS FUNCTION FIRST SWITCHES OFF THE CURSOR, THEN CREATES ALL MEMORY
STRUCTURES FOR THE ALERT BOX CALLING APPROPRIATE FUNCTIONS, THEN SEARCH FOR
THE PRESELECTED BUTTON, THEN READS KEYS (CALLING lire_alerte()), THEN FREES
ALL THE ALLOCATED MEMORY, THEN SWITCHES ON THE CURSOR, AND RETURNS TO THE
CALLING FUNCTION THE INDEX OF THE LAST SELECTED BUTTON. FOR EXAMPLE IF YOU
HAVE GOT THREE BUTTONS (e.g. OK|CANCEL|HELP) AND HELP IS THE LAST SELECTED
BUTTON THEN IT WILL RETURN 3 (INDEXES BEGIN AT 1).
WRITING A PROGRAM WHICH WANTS TO USE ALERT BOXES ONLY NEEDS TO KNOW HOW
WORKS THIS FUNCTION. THE FIRST PARAMETER IS THE INDEX OF THE PRESELECTED
BUTTON,THE SECOND ONE IS THE TITLE OF THE ALERT BOX, THE THIRD ONE IS
THE STRING OF ALL BUTTONS YOU WANT, SEPARATED BY PIPES CHARACTER ('|').
FOR EXAMPLE:    userchoice = alerte(2, "Choose what you want"
"Ok|Cancel|Help");
                THE CANCEL BUTTON IS THE PRESELECTED ONE.
 ..........................      */
{
        int retcode;            /* code de retour */
                                /* code of retur */
        register int i;         /* compteur */
                                /* counter */
        PTBUTTON b;             /* pointeur sur le bouton recherche */
                                /* pointer to the button requested */
        PTALERTE palerte;   /* pointeur sur la boite d'alerte */
                                /* pointer to the box of the alert */
                                
        inputmode = DIALOGMODE;                                        

        eteint_curseur();       /* eteint le curseur */
                                /* switches off the cursor */

        palerte = cree_alerte(title, buttons);
        if (palerte != NULL)
        {
                        /* recherche le bouton pre-selecte */
                        /* request the button selected */
                for (i = 1, b = palerte->bfirst; i < selected; i++)
                        b = b->bsuiv;
                palerte->bselected = b;

                retcode = lire_alerte(palerte);

                detruit_alerte(palerte);
        }
        else
                retcode = ERROR;

                /* remet le curseur d'origine */
                /* put back the curosor of the original */
        restaure_curseur();

        inputmode = NORMALMODE;
        
        if (resizewin)
                restart_screen_again();
                
                /* renvoie la valeur lue a l'appelant */
                /* send back the read value to the caller */
        return(retcode);
}
/**********************************************************************/
