##############################################################
# K3D_CHECK_XML_PARSER - tests for an installed xml parser

AC_DEFUN([K3D_CHECK_XML_PARSER], [
AC_SUBST(K3D_XML_PARSER_CPPFLAGS)
AC_SUBST(K3D_XML_PARSER_LIBS)

AC_ARG_WITH(libxml2, [  --with-libxml2          force use of the libxml2 library instead of expat [[no]]],[k3d_force_libxml=$withval],[k3d_force_libxml=no])

AC_CHECK_HEADER([expat.h], [], [k3d_have_expat="no"])

if test x$k3d_have_expat != xno && test x$k3d_force_libxml != xyes; then

	K3D_XML_PARSER_CPPFLAGS=
	K3D_XML_PARSER_LIBS=-lexpat
	AC_DEFINE([K3D_HAVE_EXPAT], [1], [Define to 1 if you are building with expat])

	AC_MSG_CHECKING([for an XML parser])
	AC_MSG_RESULT([found expat])	

elif [pkg-config --exists libxml-2.0]; then

	K3D_XML_PARSER_VERSION=`pkg-config --modversion libxml-2.0`
	K3D_XML_PARSER_CPPFLAGS=`pkg-config --cflags libxml-2.0`
	K3D_XML_PARSER_LIBS=`pkg-config --libs libxml-2.0`
	AC_DEFINE([K3D_HAVE_LIBXML2], [1], [Define to 1 if you are building with libxml2])

	AC_MSG_CHECKING([for an XML parser])
	AC_MSG_RESULT([found libxml version $K3D_XML_PARSER_VERSION])

else

	AC_MSG_CHECKING([for an XML parser])
	AC_MSG_ERROR([xml parser required but not found])

fi

])

