########################################################
# K3D_WITH_PYTHON

AC_DEFUN([K3D_WITH_PYTHON], [
AC_SUBST(K3D_PYTHON_SUBDIR)
AC_SUBST(K3D_PYTHON_CPPFLAGS)
AC_SUBST(K3D_PYTHON_LIBADD)
AC_SUBST(K3D_PYTHON_LDFLAGS)
AC_ARG_WITH(python,[  --with-python[[=PATH]]    build python-based script engine [[yes]]],[],[withval=yes])
if test x$withval != xno; then
	if test -z "$PYTHON"; then
		AC_PATH_PROGS(PYTHON, python2.4 python2.3 python2.2 python)
	fi
	changequote(, )
	K3D_PYTHON_VERSION=`$PYTHON -c "import sys; print sys.version[:3]"`
	changequote([, ])
	AC_MSG_RESULT([found Python version $K3D_PYTHON_VERSION])
	if test x$withval = xyes; then
		k3d_python_prefix=/usr
	else
		k3d_python_prefix=$withval
	fi

	AC_CHECK_HEADER([$k3d_python_prefix/include/python${K3D_PYTHON_VERSION}/Python.h],
	[
		K3D_PYTHON_SUBDIR="python"
		K3D_PYTHON_CPPFLAGS="-I$k3d_python_prefix/include/python${K3D_PYTHON_VERSION}"
		K3D_PYTHON_LIBADD="-L$k3d_python_prefix/lib/python${K3D_PYTHON_VERSION}/config -lpython${K3D_PYTHON_VERSION} -lutil"
		K3D_PYTHON_LDFLAGS="-Xlinker -export-dynamic"
	],
	[
	AC_MSG_RESULT([
Couldn't find Python.h ...

If you wish to include support and have Python installed in a directory
configure can't find, try specify the basepath to library and header:

	./configure --with-python=/usr/local

To find out the path, type:

	locate Python.h

If the above return '/usr/local/include/python2.X/Python.h' the basepath
will in that case be '/usr/local'.
	])
	])
fi
])

