/*
    Kamefu, KDE All-Machine Emulator Frontend for UNIX
    Also a collection manager in its spare time ;)

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "kamefuapplication.h"

static const char description[] =
    I18N_NOOP("Kamefu, KDE All-Machine Emulator Frontend for UNIX");

static const char version[] = "0.1.1";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
	KAboutData about("kamefu", I18N_NOOP("Kamefu"), version, description,
		     KAboutData::License_GPL, I18N_NOOP("(C) 2005-2006 Kamefu Developers"), 0, "http://kamefu.pwsp.net/");
    about.addAuthor("Michaël Larouche", I18N_NOOP("Project Founder, Lead Developer"), "michael.larouche@kdemail.net", "http://mlarouche.blogspot.com/");
    about.addAuthor("Brian S. Stephan", I18N_NOOP("Developer"), "bssteph@incorporeal.org", "http://www.incorporeal.org/");
	about.addCredit("Dominik Schmidt", I18N_NOOP("Webmaster, moral support, german translator"), "ich@dominik-schmidt.de", "http://www.dominik-schmidt.de/");
	about.addCredit("Aiua", I18N_NOOP("Patch for filters."), "aiua@bakani.net");
	about.setTranslator( I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"), I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails") );

	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );
	KUniqueApplication::addCmdLineOptions();

	KamefuApplication kamefu;

	return kamefu.exec();
}

