
/*
 * Kanatest
 *
 * Copyright (C) 2001 Tomasz Mka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include <time.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "gui.h"
#include "main.h"
#include "prefs.h"
#include "test.h"
#include "i18n.h"

#include "icon.h"
#include "logo.h"

#include "about.h"

static GtkWidget		*main_window = NULL;
static GtkWidget 		*stat_window = NULL;
static GtkWidget 		*about_window = NULL;

static GdkPixbuf		*pixmap = NULL;
static GdkPixbuf		*pixmap_logo = NULL;
static GtkWidget		*logo_area;

static GtkWidget 		*start_button;
static GtkWidget 		*stat_button;
static GtkWidget 		*quit_button;
static GtkWidget 		*hiragana_radio;
static GtkWidget 		*katakana_radio;
static GtkWidget 		*mixed_radio;
static GtkProgressBar	*progressbar;
static GtkWidget 		*option_button;
static GtkWidget 		*about_button;
static GtkWidget 		*frame_tm;
static GtkWidget 		*frame_ro;
static GdkBitmap		*icon_mask;
static GdkPixmap 		*icon;
static GtkStyle			*style;

/*--------------------------------------------------------------------*/

GtkWidget 		*rm_entry;
GtkWidget 		*stop_button;
gint			stop_flag = FALSE;
time_t			timer_int_l;

/*--------------------------------------------------------------------*/

GtkWidget* gui_stock_label_button(gchar *blabel, const gchar *bstock)
{
GtkWidget	*button;
GtkWidget	*alignment;
GtkWidget	*hbox;
GtkWidget	*image;

	button = g_object_new (GTK_TYPE_BUTTON, "visible", TRUE, NULL);

	alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	hbox = gtk_hbox_new (FALSE, 2);
	gtk_container_add (GTK_CONTAINER (alignment), hbox);

	image = gtk_image_new_from_stock (bstock, GTK_ICON_SIZE_BUTTON);
	if (image)
		gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, TRUE, 0);

	if (blabel)
	gtk_box_pack_start (GTK_BOX (hbox),
		g_object_new (GTK_TYPE_LABEL, "label", blabel, "use_underline", TRUE, NULL),
		FALSE, TRUE, 0);

	gtk_widget_show_all (alignment);
	gtk_container_add (GTK_CONTAINER (button), alignment);

	return button;
}

/*--------------------------------------------------------------------*/

void gui_set_progress (void)
{
gchar buffer[buffer_size];

	sprintf (buffer, "[ %d / %d ]", (q_counter + 1), max_entries);
    gtk_progress_bar_set_text (GTK_PROGRESS_BAR (progressbar), buffer);
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (progressbar), (float)(q_counter) / max_entries);
}

/*--------------------------------------------------------------------*/

void buttons_handler ( GtkWidget *widget, gpointer data )
{
	switch((gint)data) {

	case B_STATS:	/* STATS */
			gui_stat_create_window (STAT);
			break;	

	case B_ABOUT:	/* ABOUT */
			gui_about_create_window ();
			break;	

	case B_STOP:	/* STOP */
			gui_disable_test ();
			break;	

	case B_START:	/* START */
			q_counter = a_counter = qc = qn = 0;

			if (test_mode == MIXED)
				max_entries = MAX_SIGNS;
			else
				max_entries = N_SIGNS;

			gui_set_widgets_status (0);
			gtk_widget_grab_focus (rm_entry);

			test_gen_htab (max_entries);
			gui_set_progress ();

			gui_put_sign (qst_h[q_counter], test_mode);

			timer_int_l = time (NULL);
			break;	

	default:
			break;
	}
}

/*--------------------------------------------------------------------*/

void gui_disable_test (void)
{
	gui_set_widgets_status (1);

    gtk_progress_bar_set_text (GTK_PROGRESS_BAR (progressbar), 
								_("Select test mode and press [ Start ]"));
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (progressbar), 0.0);
	gtk_entry_set_text (GTK_ENTRY(rm_entry), "");

	gtk_image_set_from_pixbuf (GTK_IMAGE (logo_area), pixmap_logo);
	gtk_widget_grab_focus (start_button);
}

/*--------------------------------------------------------------------*/

void gui_set_widgets_status (gint mode)
{
gboolean st_a, st_b;

	st_a = TRUE;
	st_b = FALSE;

	if(mode) {
		st_a = FALSE;
		st_b = TRUE;
	}		

	gtk_widget_set_sensitive (rm_entry, st_a);
	gtk_widget_set_sensitive (frame_ro, st_a);
	gtk_widget_set_sensitive (stop_button, st_a);

	gtk_widget_set_sensitive (start_button, st_b);
	gtk_widget_set_sensitive (stat_button, st_b);
	gtk_widget_set_sensitive (quit_button, st_b);
	gtk_widget_set_sensitive (hiragana_radio, st_b);
	gtk_widget_set_sensitive (katakana_radio, st_b);
	gtk_widget_set_sensitive (mixed_radio, st_b);
	gtk_widget_set_sensitive (option_button, st_b);
	gtk_widget_set_sensitive (about_button, st_b);
	gtk_widget_set_sensitive (frame_tm, st_b);

}

/*--------------------------------------------------------------------*/

void gui_put_sign (gint number, gint mode)
{
gchar tmp_file[MAX_PATH];

	switch (mode) {
		case HIRAGANA:
			s_strcpy (tmp_file, hiragana_path, MAX_PATH);
			break;
		case KATAKANA:
			s_strcpy (tmp_file, katakana_path, MAX_PATH);
			break;
		case ROMAJI:
			s_strcpy (tmp_file, romaji_path, MAX_PATH);
			break;
		case MIXED:
			if (number >= N_SIGNS) {
				s_strcpy (tmp_file, katakana_path, MAX_PATH);
			} else {
				s_strcpy (tmp_file, hiragana_path, MAX_PATH);
			}
			break;
		default:
			fprintf (stderr, "WARNING: Invalid mode selected.\n");
			break;
	}

	s_strcat (tmp_file, jsigns[number % N_SIGNS], MAX_PATH);
	s_strcat (tmp_file, ".png", MAX_PATH);

	pixmap = gdk_pixbuf_new_from_file (tmp_file, NULL);

	if (pixmap)

		gtk_image_set_from_pixbuf (GTK_IMAGE (logo_area), pixmap);

	else {
		fprintf (stderr, "ERROR: file not found (check installation).\n");
		exit (-1);
	}
}

/*--------------------------------------------------------------------*/

gchar* input_clean(gchar *word)
{
static gchar rebuf[buffer_size];
gchar *acharstab = { "abcdefghijklmnoprstuwyz" };	/* 23 chars */
gint i, j, k, l, f;
gchar c;

	k = strlen(word);	
	if(k > 6) k = 6;

	for (i = j = 0; i < k; i++) {

		rebuf[j] = '\0';
		c = tolower(word[i]);

		for(l = f = 0; l < 23; l++)
			if(acharstab[l] == c) f++;

		if(f) rebuf[j++] = c;

	}
	rebuf[j] = '\0';

	return rebuf;
}

/*--------------------------------------------------------------------*/

int rm_key_press (GtkWidget *widget, GdkEventKey *event, gpointer data)
{

	switch (event->keyval) {

		case GDK_Escape:
			gtk_entry_set_text (GTK_ENTRY(rm_entry), "");
			break;

		case GDK_Return:
			gtk_entry_set_text (GTK_ENTRY(rm_entry), 
				input_clean((gchar*)gtk_entry_get_text (GTK_ENTRY(rm_entry))));
            if (strlen (input_clean((gchar*)gtk_entry_get_text (GTK_ENTRY(rm_entry)))))
				test_main ((gchar*)(gtk_entry_get_text (GTK_ENTRY(rm_entry))));
			break;

	}

	return FALSE;
}

/*--------------------------------------------------------------------*/

void testmode_select (GtkWidget *entry, GtkUpdateType type)
{
	test_mode = type;
}

/*--------------------------------------------------------------------*/

void repeat_wrong_changed( GtkToggleButton *button )
{
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(button)) == TRUE)
		config.repeat_wrong = TRUE;
	else
		config.repeat_wrong = FALSE;
}

/*--------------------------------------------------------------------*/

void gui_close_window( GtkWidget *widget, gpointer data )
{
	gtk_window_get_size (GTK_WINDOW(main_window),
						&config.window_size_x, &config.window_size_y);
	gdk_window_get_root_origin (main_window->window,
								&config.window_x, &config.window_y);

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(hiragana_radio)) == TRUE)
		config.last_mode = HIRAGANA;
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(katakana_radio)) == TRUE)
		config.last_mode = KATAKANA;
	else
		config.last_mode = MIXED;

	repeat_wrong_changed(GTK_TOGGLE_BUTTON(option_button));

	gtk_main_quit ();
}

/*--------------------------------------------------------------------*/

void gui_create_window (void)
{
GtkWidget 		*frame1;
GtkWidget 		*vbox0;
GtkWidget 		*vbox1;
GtkWidget 		*hseparator1;
GtkWidget 		*hseparator2;
GtkWidget 		*frame2;
GtkWidget 		*frame4;
GtkWidget 		*hbox1, *hbox2;
GSList 			*hbox1_group = NULL;
GtkWidget 		*hbuttonbox1;
GtkWidget 		*label;
static gchar	tmpbuf[buffer_size];
GtkTooltips		*tooltips; 


	tooltips = gtk_tooltips_new();

	main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width (GTK_CONTAINER (main_window), 4);
	gtk_window_set_title (GTK_WINDOW (main_window), "Kanatest " VERSION);

	gtk_window_set_default_size (GTK_WINDOW(main_window), 
								config.window_size_x, config.window_size_y);

	gtk_window_set_resizable (GTK_WINDOW (main_window), TRUE);

	gtk_window_move (GTK_WINDOW (main_window),
								config.window_x, config.window_y);

	g_signal_connect (G_OBJECT (main_window), "delete_event",
						G_CALLBACK(gui_close_window), NULL);

	gtk_widget_show (main_window);

	vbox0 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox0);
	gtk_container_add (GTK_CONTAINER (main_window), vbox0);

	frame1 = gtk_frame_new (NULL);
	gtk_widget_show (frame1);
	gtk_container_set_border_width (GTK_CONTAINER (frame1), 4);
	gtk_box_pack_start (GTK_BOX (vbox0), frame1, TRUE, TRUE, 0);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (frame1), vbox1);

	pixmap_logo = gdk_pixbuf_new_from_xpm_data (logo_xpm);
	logo_area = gtk_image_new_from_pixbuf (pixmap_logo);
	gtk_widget_show(logo_area);
	gtk_box_pack_start (GTK_BOX (vbox1), logo_area, TRUE, TRUE, 0);

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_show (hseparator1);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 0);

	progressbar = GTK_PROGRESS_BAR(gtk_progress_bar_new());
	gtk_widget_show (GTK_WIDGET(progressbar));
	gtk_box_pack_start (GTK_BOX (vbox1), GTK_WIDGET(progressbar), FALSE, FALSE, 0);

	hseparator2 = gtk_hseparator_new ();
	gtk_widget_show (hseparator2);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator2, FALSE, TRUE, 0);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);

	sprintf (tmpbuf, "<i><b>Romaji: </b></i>");
	frame_ro = gtk_frame_new (NULL);
	gtk_widget_show (frame_ro);
	gtk_box_pack_start (GTK_BOX (hbox1), frame_ro, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame_ro), 6);

	label = gtk_label_new (NULL);
	gtk_widget_show (label);
	gtk_frame_set_label_widget (GTK_FRAME(frame_ro), label);
	gtk_label_set_markup (GTK_LABEL (label), tmpbuf);

	frame4 = gtk_frame_new (NULL);
	gtk_widget_show (frame4);
	gtk_container_add (GTK_CONTAINER (frame_ro), frame4);
	gtk_container_set_border_width (GTK_CONTAINER (frame4), 2);
	gtk_frame_set_shadow_type (GTK_FRAME (frame4), GTK_SHADOW_NONE);

	rm_entry = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(rm_entry), 3);
	g_signal_connect (G_OBJECT(rm_entry), "key_press_event",
						G_CALLBACK(rm_key_press), NULL);
	gtk_widget_set_size_request(rm_entry, 90, -1);
	gtk_widget_show (rm_entry);
	gtk_container_add (GTK_CONTAINER (frame4), rm_entry);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (hbox1), hbox2, TRUE, FALSE, 0);

	frame2 = gtk_frame_new (NULL);
	gtk_widget_show (frame2);
	gtk_box_pack_start (GTK_BOX (hbox1), frame2, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_NONE);
	gtk_container_set_border_width (GTK_CONTAINER (frame2), 10);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox2);
	gtk_container_add (GTK_CONTAINER (frame2), hbox2);

	stat_button = gui_stock_label_button(NULL, GTK_STOCK_FIND);
	gtk_button_set_relief (GTK_BUTTON (stat_button), GTK_RELIEF_NONE);
	g_signal_connect (G_OBJECT (stat_button), "clicked",
						G_CALLBACK (buttons_handler), (gpointer)B_STATS);
	gtk_widget_show (stat_button);
	gtk_box_pack_start (GTK_BOX (hbox2), stat_button, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (stat_button), 2);
	gtk_tooltips_set_tip (tooltips, stat_button, "Statistics", NULL);

	about_button = gui_stock_label_button(NULL, GTK_STOCK_HOME);
	gtk_button_set_relief (GTK_BUTTON (about_button), GTK_RELIEF_NONE);
	g_signal_connect (G_OBJECT (about_button), "clicked",
						G_CALLBACK (buttons_handler), (gpointer)B_ABOUT);
	gtk_widget_show (about_button);
	gtk_box_pack_start (GTK_BOX (hbox2), about_button, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (about_button), 2);
	gtk_tooltips_set_tip (tooltips, about_button, "About", NULL);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 0);

	frame4 = gtk_frame_new (NULL);
	gtk_widget_show (frame4);
	gtk_box_pack_start (GTK_BOX (hbox2), frame4, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame4), 3);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (frame4), hbox1);

    option_button = gtk_check_button_new_with_label(_("Repeat wrongly-answered questions"));
    g_signal_connect (G_OBJECT (option_button), "toggled",
                      G_CALLBACK (repeat_wrong_changed), NULL);
    gtk_box_pack_start (GTK_BOX (hbox1), option_button, TRUE, TRUE, 0);
    gtk_widget_show (option_button);
	gtk_tooltips_set_tip (tooltips, option_button, "When this option is enabled the kanatest will repeat all wrongly answered questions at the end of test...", NULL);

	sprintf (tmpbuf, _("<i><b>Test mode: </b></i>"));
	frame_tm = gtk_frame_new (NULL);
	gtk_widget_show (frame_tm);
	gtk_box_pack_start (GTK_BOX (vbox1), frame_tm, FALSE, TRUE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (frame_tm), GTK_SHADOW_NONE);
	gtk_container_set_border_width (GTK_CONTAINER (frame_tm), 3);

	label = gtk_label_new (NULL);
	gtk_widget_show (label);
	gtk_frame_set_label_widget (GTK_FRAME(frame_tm), label);
	gtk_label_set_markup (GTK_LABEL (label), tmpbuf);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (frame_tm), hbox1);

	hiragana_radio = gtk_radio_button_new_with_label (hbox1_group, "Hiragana");
	hbox1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (hiragana_radio));
	gtk_widget_show (hiragana_radio);
	g_signal_connect (G_OBJECT (hiragana_radio), "clicked",
						G_CALLBACK (testmode_select),
					    GINT_TO_POINTER (HIRAGANA));
	gtk_box_pack_start (GTK_BOX (hbox1), hiragana_radio, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hiragana_radio), 2);

	katakana_radio = gtk_radio_button_new_with_label (hbox1_group, "Katakana");
	hbox1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (katakana_radio));
	gtk_widget_show (katakana_radio);
	g_signal_connect (G_OBJECT (katakana_radio), "clicked",
						G_CALLBACK (testmode_select),
					    GINT_TO_POINTER (KATAKANA));
	gtk_box_pack_start (GTK_BOX (hbox1), katakana_radio, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (katakana_radio), 2);

	mixed_radio = gtk_radio_button_new_with_label (hbox1_group, _("Mixed"));
	hbox1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (mixed_radio));
	gtk_widget_show (mixed_radio);
	g_signal_connect (G_OBJECT (mixed_radio), "clicked",
						G_CALLBACK (testmode_select),
					    GINT_TO_POINTER (MIXED));
	gtk_box_pack_start (GTK_BOX (hbox1), mixed_radio, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (mixed_radio), 2);

	hbuttonbox1 = gtk_hbutton_box_new ();
	gtk_widget_show (hbuttonbox1);
	gtk_box_pack_start (GTK_BOX (vbox0), hbuttonbox1, FALSE, TRUE, 0);
	gtk_box_set_spacing (GTK_BOX (hbuttonbox1), 5);

	start_button = gui_stock_label_button(_("_Start"), GTK_STOCK_EXECUTE);
	g_signal_connect (G_OBJECT (start_button), "clicked",
						G_CALLBACK (buttons_handler), (gpointer)B_START);
	gtk_widget_show (start_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), start_button);
	gtk_container_set_border_width (GTK_CONTAINER (start_button), 4);
	GTK_WIDGET_SET_FLAGS (start_button, GTK_CAN_DEFAULT);

	stop_button = gtk_button_new_from_stock (GTK_STOCK_STOP);
	g_signal_connect (G_OBJECT (stop_button), "clicked",
						G_CALLBACK (buttons_handler), (gpointer)B_STOP);
	gtk_widget_show (stop_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), stop_button);
	gtk_container_set_border_width (GTK_CONTAINER (stop_button), 4);
	GTK_WIDGET_SET_FLAGS (stop_button, GTK_CAN_DEFAULT);

	quit_button = gtk_button_new_from_stock (GTK_STOCK_QUIT);
	g_signal_connect (G_OBJECT (quit_button), "clicked",
						G_CALLBACK (gui_close_window), NULL);
	gtk_widget_show (quit_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), quit_button);
	gtk_container_set_border_width (GTK_CONTAINER (quit_button), 4);
	GTK_WIDGET_SET_FLAGS (quit_button, GTK_CAN_DEFAULT);

	style = gtk_widget_get_style(GTK_WIDGET(main_window));
	icon = gdk_pixmap_create_from_xpm_d (main_window->window, &icon_mask, &style->bg[GTK_STATE_NORMAL], icon_xpm);
	gdk_window_set_icon (main_window->window, NULL, icon, icon_mask);

	gui_disable_test ();

	if (test_mode == HIRAGANA)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(hiragana_radio), TRUE);
	else if (test_mode == KATAKANA)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(katakana_radio), TRUE);
	else
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(mixed_radio), TRUE);

	if (config.repeat_wrong == TRUE)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(option_button), TRUE);

}
/*--------------------------------------------------------------------*/

void gui_stat_window_close(void)
{
	gdk_window_get_root_origin (stat_window->window,
								&config.stat_window_x, &config.stat_window_y);

	gtk_widget_destroy (stat_window);
	stat_window = NULL;
}



void gui_stat_create_window (gint mode)
{
GtkWidget		*vbox1;
GtkWidget		*frame1;
GtkWidget		*vbox2;
GtkWidget		*hbox1, *hbox8, *hbox2, *hbox10, *hbox9;
GtkWidget		*h_label_1, *hi_label_1 = NULL;
GtkWidget		*h_label_2, *hi_label_2 = NULL;
GtkWidget		*h_label_3, *hi_label_3;
GtkWidget		*h_label_4, *hi_label_4 = NULL;
GtkWidget		*h_label_5, *hi_label_5;
GtkWidget		*frame2;
GtkWidget		*vbox3;
GtkWidget		*vbox5;
GtkWidget		*hbox11, *hbox12, *hbox13, *hbox14, *hbox15;
GtkWidget		*k_label_1, *ki_label_1 = NULL;
GtkWidget		*k_label_2, *ki_label_2 = NULL;
GtkWidget		*k_label_3, *ki_label_3;
GtkWidget		*k_label_4, *ki_label_4 = NULL;
GtkWidget		*k_label_5, *ki_label_5;
GtkWidget		*frame3;
GtkWidget		*vbox4, *vbox6;
GtkWidget		*hbox16;
GtkWidget		*hbox17, *hbox18, *hbox19, *hbox20;
GtkWidget		*m_label_1, *mi_label_1 = NULL;
GtkWidget		*m_label_2, *mi_label_2 = NULL;
GtkWidget		*m_label_3, *mi_label_3;
GtkWidget		*m_label_4, *mi_label_4 = NULL;
GtkWidget		*m_label_5, *mi_label_5;
GtkWidget		*hbuttonbox1;
GtkWidget		*close_button;
GtkWidget		*label;
GtkWidget		*hseparator1;

gchar tmpbuffer1[buffer_size], tmpbuffer2[buffer_size], tmpbuffer3[buffer_size];

	if(stat_window != NULL) {
		gdk_window_raise (stat_window->window);
		return;
	}

	stat_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_transient_for(GTK_WINDOW(stat_window),GTK_WINDOW(main_window));
	gtk_window_set_resizable (GTK_WINDOW (stat_window), TRUE);
   	gtk_window_set_modal(GTK_WINDOW(stat_window), TRUE);
	gtk_container_set_border_width (GTK_CONTAINER (stat_window), 6);
	gtk_window_set_title (GTK_WINDOW (stat_window), _("Statistics"));

	if(mode != STAT)
		gtk_widget_set_size_request (stat_window, 350, 430);
	else
		gtk_widget_set_size_request (stat_window, 350, 280);

	g_signal_connect (G_OBJECT (stat_window), "delete_event",
						G_CALLBACK(gui_stat_window_close), NULL);

	gtk_window_move (GTK_WINDOW (stat_window),
								config.stat_window_x, config.stat_window_y);

	gtk_widget_show (stat_window);

	style = gtk_widget_get_style(GTK_WIDGET(stat_window));
	icon = gdk_pixmap_create_from_xpm_d (stat_window->window, &icon_mask, &style->bg[GTK_STATE_NORMAL], icon_xpm);
	gdk_window_set_icon (stat_window->window, NULL, icon, icon_mask);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (stat_window), vbox1);

	sprintf (tmpbuffer1, _("<span size='large'><b>HIRAGANA MODE - %d test(s)</b></span>"), config.hiragana_counter);

	frame1 = gtk_frame_new (NULL);
	gtk_widget_show (frame1);
	gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);
	gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame1), 4);

	label = gtk_label_new (NULL);
	gtk_widget_show (label);
	gtk_frame_set_label_widget (GTK_FRAME(frame1), label);
	gtk_label_set_markup (GTK_LABEL (label), tmpbuffer1);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (frame1), vbox2);

	if(mode != STAT) {
		hbox1 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox1);
		gtk_box_pack_start (GTK_BOX (vbox2), hbox1, TRUE, TRUE, 0);

		h_label_1 = gtk_label_new (_("Correct answers:"));
		gtk_widget_show (h_label_1);
		gtk_box_pack_start (GTK_BOX (hbox1), h_label_1, FALSE, FALSE, 4);

		hi_label_1 = gtk_label_new ("");
		gtk_widget_show (hi_label_1);
		gtk_box_pack_start (GTK_BOX (hbox1), hi_label_1, FALSE, FALSE, 0);

		hbox8 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox8);
		gtk_box_pack_start (GTK_BOX (vbox2), hbox8, TRUE, TRUE, 0);

		h_label_2 = gtk_label_new (_("Incorrect answers:"));
		gtk_widget_show (h_label_2);
		gtk_box_pack_start (GTK_BOX (hbox8), h_label_2, FALSE, FALSE, 4);

		hi_label_2 = gtk_label_new ("");
		gtk_widget_show (hi_label_2);
		gtk_box_pack_start (GTK_BOX (hbox8), hi_label_2, FALSE, FALSE, 0);
	}

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox2, TRUE, TRUE, 0);

	h_label_3 = gtk_label_new (_("Best result:"));
	gtk_widget_show (h_label_3);
	gtk_box_pack_start (GTK_BOX (hbox2), h_label_3, FALSE, FALSE, 4);

	hi_label_3 = gtk_label_new ("");
	gtk_widget_show (hi_label_3);
	gtk_box_pack_start (GTK_BOX (hbox2), hi_label_3, FALSE, FALSE, 0);

	if(mode != STAT) {
		hbox10 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox10);
		gtk_box_pack_start (GTK_BOX (vbox2), hbox10, TRUE, TRUE, 0);

		h_label_4 = gtk_label_new (_("This test time:"));
		gtk_widget_show (h_label_4);
		gtk_box_pack_start (GTK_BOX (hbox10), h_label_4, FALSE, FALSE, 4);

		hi_label_4 = gtk_label_new ("");
		gtk_widget_show (hi_label_4);
		gtk_box_pack_start (GTK_BOX (hbox10), hi_label_4, FALSE, FALSE, 0);
	}

	hbox9 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox9);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox9, TRUE, TRUE, 0);

	h_label_5 = gtk_label_new (_("Overall tests time:"));
	gtk_widget_show (h_label_5);
	gtk_box_pack_start (GTK_BOX (hbox9), h_label_5, FALSE, FALSE, 4);

	hi_label_5 = gtk_label_new ("");
	gtk_widget_show (hi_label_5);
	gtk_box_pack_start (GTK_BOX (hbox9), hi_label_5, FALSE, FALSE, 0);

	sprintf(tmpbuffer1, _("<span size='large'><b>KATAKANA MODE - %d test(s)</b></span>"), config.katakana_counter);

	frame2 = gtk_frame_new (NULL);
	gtk_widget_show (frame2);
	gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_IN);
	gtk_container_set_border_width (GTK_CONTAINER (frame2), 4);

	label = gtk_label_new (NULL);
	gtk_widget_show (label);
	gtk_frame_set_label_widget (GTK_FRAME(frame2), label);
	gtk_label_set_markup (GTK_LABEL (label), tmpbuffer1);

	vbox3 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox3);
	gtk_container_add (GTK_CONTAINER (frame2), vbox3);

	vbox5 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox5);
	gtk_box_pack_start (GTK_BOX (vbox3), vbox5, TRUE, TRUE, 0);

	if(mode != STAT) {
		hbox11 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox11);
		gtk_box_pack_start (GTK_BOX (vbox5), hbox11, TRUE, TRUE, 0);

		k_label_1 = gtk_label_new (_("Correct answers:"));
		gtk_widget_show (k_label_1);
		gtk_box_pack_start (GTK_BOX (hbox11), k_label_1, FALSE, FALSE, 4);

		ki_label_1 = gtk_label_new ("");
		gtk_widget_show (ki_label_1);
		gtk_box_pack_start (GTK_BOX (hbox11), ki_label_1, FALSE, FALSE, 0);

		hbox12 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox12);
		gtk_box_pack_start (GTK_BOX (vbox5), hbox12, TRUE, TRUE, 0);

		k_label_2 = gtk_label_new (_("Incorrect answers:"));
		gtk_widget_show (k_label_2);
		gtk_box_pack_start (GTK_BOX (hbox12), k_label_2, FALSE, FALSE, 4);

		ki_label_2 = gtk_label_new ("");
		gtk_widget_show (ki_label_2);
		gtk_box_pack_start (GTK_BOX (hbox12), ki_label_2, FALSE, FALSE, 0);
	}

	hbox13 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox13);
	gtk_box_pack_start (GTK_BOX (vbox5), hbox13, TRUE, TRUE, 0);

	k_label_3 = gtk_label_new (_("Best result:"));
	gtk_widget_show (k_label_3);
	gtk_box_pack_start (GTK_BOX (hbox13), k_label_3, FALSE, FALSE, 4);

	ki_label_3 = gtk_label_new ("");
	gtk_widget_show (ki_label_3);
	gtk_box_pack_start (GTK_BOX (hbox13), ki_label_3, FALSE, FALSE, 0);

	if(mode != STAT) {
		hbox14 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox14);
		gtk_box_pack_start (GTK_BOX (vbox5), hbox14, TRUE, TRUE, 0);

		k_label_4 = gtk_label_new (_("This test time:"));
		gtk_widget_show (k_label_4);
		gtk_box_pack_start (GTK_BOX (hbox14), k_label_4, FALSE, FALSE, 4);

		ki_label_4 = gtk_label_new ("");
		gtk_widget_show (ki_label_4);
		gtk_box_pack_start (GTK_BOX (hbox14), ki_label_4, FALSE, FALSE, 0);
	}

	hbox15 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox15);
	gtk_box_pack_start (GTK_BOX (vbox5), hbox15, TRUE, TRUE, 0);

	k_label_5 = gtk_label_new (_("Overall tests time:"));
	gtk_widget_show (k_label_5);
	gtk_box_pack_start (GTK_BOX (hbox15), k_label_5, FALSE, FALSE, 4);

	ki_label_5 = gtk_label_new ("");
	gtk_widget_show (ki_label_5);
	gtk_box_pack_start (GTK_BOX (hbox15), ki_label_5, FALSE, FALSE, 0);

	sprintf(tmpbuffer1, _("<span size='large'><b>MIXED MODE - %d test(s)</b></span>"), config.mixed_counter);
	
	frame3 = gtk_frame_new (NULL);
	gtk_widget_show (frame3);
	gtk_box_pack_start (GTK_BOX (vbox1), frame3, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (frame3), GTK_SHADOW_IN);
	gtk_container_set_border_width (GTK_CONTAINER (frame3), 4);

	label = gtk_label_new (NULL);
	gtk_widget_show (label);
	gtk_frame_set_label_widget (GTK_FRAME(frame3), label);
	gtk_label_set_markup (GTK_LABEL (label), tmpbuffer1);

	vbox4 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox4);
	gtk_container_add (GTK_CONTAINER (frame3), vbox4);

	vbox6 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox6);
	gtk_box_pack_start (GTK_BOX (vbox4), vbox6, TRUE, TRUE, 0);

	if(mode != STAT) {
		hbox16 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox16);
		gtk_box_pack_start (GTK_BOX (vbox6), hbox16, TRUE, TRUE, 0);

		m_label_1 = gtk_label_new (_("Correct answers:"));
		gtk_widget_show (m_label_1);
		gtk_box_pack_start (GTK_BOX (hbox16), m_label_1, FALSE, FALSE, 4);

		mi_label_1 = gtk_label_new ("");
		gtk_widget_show (mi_label_1);
		gtk_box_pack_start (GTK_BOX (hbox16), mi_label_1, FALSE, FALSE, 0);

		hbox17 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox17);
		gtk_box_pack_start (GTK_BOX (vbox6), hbox17, TRUE, TRUE, 0);

		m_label_2 = gtk_label_new (_("Incorrect answers:"));
		gtk_widget_show (m_label_2);
		gtk_box_pack_start (GTK_BOX (hbox17), m_label_2, FALSE, FALSE, 4);

		mi_label_2 = gtk_label_new ("");
		gtk_widget_show (mi_label_2);
		gtk_box_pack_start (GTK_BOX (hbox17), mi_label_2, FALSE, FALSE, 0);
	}

	hbox18 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox18);
	gtk_box_pack_start (GTK_BOX (vbox6), hbox18, TRUE, TRUE, 0);

	m_label_3 = gtk_label_new (_("Best result:"));
	gtk_widget_show (m_label_3);
	gtk_box_pack_start (GTK_BOX (hbox18), m_label_3, FALSE, FALSE, 4);

	mi_label_3 = gtk_label_new ("");
	gtk_widget_show (mi_label_3);
	gtk_box_pack_start (GTK_BOX (hbox18), mi_label_3, FALSE, FALSE, 0);

	if(mode != STAT) {
		hbox19 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox19);
		gtk_box_pack_start (GTK_BOX (vbox6), hbox19, TRUE, TRUE, 0);

		m_label_4 = gtk_label_new (_("This test time:"));
		gtk_widget_show (m_label_4);
		gtk_box_pack_start (GTK_BOX (hbox19), m_label_4, FALSE, FALSE, 4);

		mi_label_4 = gtk_label_new ("");
		gtk_widget_show (mi_label_4);
		gtk_box_pack_start (GTK_BOX (hbox19), mi_label_4, FALSE, FALSE, 0);
	}

	hbox20 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox20);
	gtk_box_pack_start (GTK_BOX (vbox6), hbox20, TRUE, TRUE, 0);

	m_label_5 = gtk_label_new (_("Overall tests time:"));
	gtk_widget_show (m_label_5);
	gtk_box_pack_start (GTK_BOX (hbox20), m_label_5, FALSE, FALSE, 4);

	mi_label_5 = gtk_label_new ("");
	gtk_widget_show (mi_label_5);
	gtk_box_pack_start (GTK_BOX (hbox20), mi_label_5, FALSE, FALSE, 0);

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_show (hseparator1);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 4);

	hbuttonbox1 = gtk_hbutton_box_new ();
	gtk_widget_show (hbuttonbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, FALSE, TRUE, 4);

	close_button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
	gtk_widget_show (close_button);
	g_signal_connect (G_OBJECT (close_button), "clicked",
						G_CALLBACK (gui_stat_window_close), NULL);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), close_button);
	GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (close_button);

	gtk_label_set_text (GTK_LABEL(hi_label_5), test_min2str(config.hiragana_time));
	gtk_label_set_text (GTK_LABEL(ki_label_5), test_min2str(config.katakana_time));
	gtk_label_set_text (GTK_LABEL(mi_label_5), test_min2str(config.mixed_time));

	sprintf(tmpbuffer1, _("%d correct answer(s)."), config.hiragana_max_result);
	gtk_label_set_text (GTK_LABEL(hi_label_3), tmpbuffer1);
	sprintf(tmpbuffer1, _("%d correct answer(s)."), config.katakana_max_result);
	gtk_label_set_text (GTK_LABEL(ki_label_3), tmpbuffer1);
	sprintf(tmpbuffer1, _("%d correct answer(s)."), config.mixed_max_result);
	gtk_label_set_text (GTK_LABEL(mi_label_3), tmpbuffer1);

	sprintf(tmpbuffer1, "%d", qn - a_counter);
	sprintf(tmpbuffer2, "%d", a_counter);
	sprintf(tmpbuffer3, _("%.2f minutes."), tval);

	if(mode!=STAT) {
		gtk_widget_set_sensitive (frame1, FALSE);
		gtk_label_set_text (GTK_LABEL(hi_label_1), "-");
		gtk_label_set_text (GTK_LABEL(hi_label_2), "-");
		gtk_label_set_text (GTK_LABEL(hi_label_4), "-");
		gtk_widget_set_sensitive (frame2, FALSE);
		gtk_label_set_text (GTK_LABEL(ki_label_1), "-");
		gtk_label_set_text (GTK_LABEL(ki_label_2), "-");
		gtk_label_set_text (GTK_LABEL(ki_label_4), "-");
		gtk_widget_set_sensitive (frame3, FALSE);
		gtk_label_set_text (GTK_LABEL(mi_label_1), "-");
		gtk_label_set_text (GTK_LABEL(mi_label_2), "-");
		gtk_label_set_text (GTK_LABEL(mi_label_4), "-");
	}

	if(config.repeat_wrong == FALSE) {

		switch (mode) {
			case HIRAGANA:
				gtk_widget_set_sensitive (frame1, TRUE);
				gtk_label_set_text (GTK_LABEL(hi_label_1), tmpbuffer1);
				gtk_label_set_text (GTK_LABEL(hi_label_2), tmpbuffer2);
				gtk_label_set_text (GTK_LABEL(hi_label_4), tmpbuffer3);
				break;

			case KATAKANA:
				gtk_widget_set_sensitive (frame2, TRUE);
				gtk_label_set_text (GTK_LABEL(ki_label_1), tmpbuffer1);
				gtk_label_set_text (GTK_LABEL(ki_label_2), tmpbuffer2);
				gtk_label_set_text (GTK_LABEL(ki_label_4), tmpbuffer3);
				break;

			case MIXED:
				gtk_widget_set_sensitive (frame3, TRUE);
				gtk_label_set_text (GTK_LABEL(mi_label_1), tmpbuffer1);
				gtk_label_set_text (GTK_LABEL(mi_label_2), tmpbuffer2);
				gtk_label_set_text (GTK_LABEL(mi_label_4), tmpbuffer3);
				break;

			case STAT:
				break;

			default:
				fprintf(stderr, "WARNING: Invalid mode selected.\n");
				break;
		}

	} else {

		switch (mode) {
			case HIRAGANA:
				gtk_widget_set_sensitive (frame1, TRUE);
				gtk_label_set_text (GTK_LABEL(hi_label_4), tmpbuffer3);
				break;

			case KATAKANA:
				gtk_widget_set_sensitive (frame2, TRUE);
				gtk_label_set_text (GTK_LABEL(ki_label_4), tmpbuffer3);
				break;

			case MIXED:
				gtk_widget_set_sensitive (frame3, TRUE);
				gtk_label_set_text (GTK_LABEL(mi_label_4), tmpbuffer3);
				break;

			case STAT:
				break;

			default:
				fprintf(stderr, "WARNING: Invalid mode selected.\n");
				break;
		}


	}

}

/*--------------------------------------------------------------------*/

void gui_about_window_close(void)
{
	gdk_window_get_root_origin (about_window->window,
								&config.about_window_x, &config.about_window_y);

	gtk_widget_destroy (about_window);
	about_window = NULL;
}



void gui_about_create_window (void)
{
GtkWidget		*vbox1;
GtkWidget		*vbox2;
GtkWidget		*hseparator1;
GtkWidget		*hbuttonbox1;
GtkWidget		*close_button;
GtkWidget		*notebook;
GtkWidget		*label;
GtkWidget		*scrolled_window;
GtkTextBuffer	*entry_buffer = NULL;
GtkWidget		*text_sheet = NULL;
GtkTextIter iter;

	if(about_window != NULL) {
		gdk_window_raise (about_window->window);
		return;
	}

	about_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_transient_for(GTK_WINDOW(about_window),GTK_WINDOW(main_window));
	gtk_window_set_resizable (GTK_WINDOW (about_window), TRUE);
   	gtk_window_set_modal(GTK_WINDOW(about_window), TRUE);
	gtk_container_set_border_width (GTK_CONTAINER (about_window), 8);
	gtk_window_set_title (GTK_WINDOW (about_window), _("About"));
	gtk_widget_set_size_request (about_window, 370, 380);

	g_signal_connect (G_OBJECT (about_window), "delete_event",
						G_CALLBACK(gui_about_window_close), NULL);

	gtk_window_move (GTK_WINDOW (about_window),
								config.about_window_x, config.about_window_y);

	gtk_widget_show (about_window);

	style = gtk_widget_get_style(GTK_WIDGET(about_window));
	icon = gdk_pixmap_create_from_xpm_d (about_window->window, &icon_mask, &style->bg[GTK_STATE_NORMAL], icon_xpm);
	gdk_window_set_icon (about_window->window, NULL, icon, icon_mask);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (about_window), vbox1);

    notebook = gtk_notebook_new ();
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
    gtk_widget_show (notebook);
	gtk_box_pack_start (GTK_BOX (vbox1), notebook, TRUE, TRUE, 0);

	/*-----------------------------------------------------------------*/

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox2);

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolled_window);

	entry_buffer = gtk_text_buffer_new (NULL);
	gtk_text_buffer_get_iter_at_offset (entry_buffer, &iter, 0);
	gtk_text_buffer_create_tag (entry_buffer, "underline",
			      "underline", PANGO_UNDERLINE_SINGLE, NULL);
	gtk_text_buffer_create_tag (entry_buffer, "big",
			      "size", 12 * PANGO_SCALE, NULL);
	gtk_text_buffer_get_iter_at_offset (entry_buffer, &iter, 0);
	text_sheet = gtk_text_view_new_with_buffer (entry_buffer);
	gtk_container_set_border_width (GTK_CONTAINER (text_sheet), 1);
	gtk_text_view_set_editable(GTK_TEXT_VIEW (text_sheet), FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW (text_sheet), FALSE);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (text_sheet), GTK_WRAP_WORD);
	gtk_widget_show (text_sheet);
	gtk_container_add (GTK_CONTAINER (scrolled_window), text_sheet);

	gtk_text_buffer_insert_with_tags_by_name (entry_buffer, &iter,
					    "\nAuthors\n\n", -1, 
					    "underline", "big", NULL);

	gtk_text_buffer_insert (entry_buffer, &iter, text_authors, -1);

	gtk_text_buffer_insert_with_tags_by_name (entry_buffer, &iter,
					    "Borrowed code\n\n", -1, 
					    "underline", "big", NULL);

	gtk_text_buffer_insert (entry_buffer, &iter, text_authors_borrowed, -1);

	label = gtk_label_new (_("Authors"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox2, label);

	/*-----------------------------------------------------------------*/

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox2);

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolled_window);

	entry_buffer = gtk_text_buffer_new (NULL);
	gtk_text_buffer_get_iter_at_offset (entry_buffer, &iter, 0);
	gtk_text_buffer_create_tag (entry_buffer, "underline",
			      "underline", PANGO_UNDERLINE_SINGLE, NULL);
	gtk_text_buffer_create_tag (entry_buffer, "big",
			      "size", 12 * PANGO_SCALE, NULL);
	gtk_text_buffer_get_iter_at_offset (entry_buffer, &iter, 0);
	text_sheet = gtk_text_view_new_with_buffer (entry_buffer);
	gtk_container_set_border_width (GTK_CONTAINER (text_sheet), 1);
	gtk_text_view_set_editable(GTK_TEXT_VIEW (text_sheet), FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW (text_sheet), FALSE);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (text_sheet), GTK_WRAP_WORD);
	gtk_widget_show (text_sheet);
	gtk_container_add (GTK_CONTAINER (scrolled_window), text_sheet);

	gtk_text_buffer_insert_with_tags_by_name (entry_buffer, &iter,
					    "\nThanks\n\n", -1, 
					    "underline", "big", NULL);

	gtk_text_buffer_insert (entry_buffer, &iter, text_thanks, -1);

	label = gtk_label_new (_("Thanks"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox2, label);

	/*-----------------------------------------------------------------*/

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox2);

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolled_window);

	entry_buffer = gtk_text_buffer_new (NULL);
	gtk_text_buffer_get_iter_at_offset (entry_buffer, &iter, 0);
	gtk_text_buffer_create_tag (entry_buffer, "underline",
			      "underline", PANGO_UNDERLINE_SINGLE, NULL);
	gtk_text_buffer_create_tag (entry_buffer, "big",
			      "size", 12 * PANGO_SCALE, NULL);
	gtk_text_buffer_get_iter_at_offset (entry_buffer, &iter, 0);
	text_sheet = gtk_text_view_new_with_buffer (entry_buffer);
	gtk_container_set_border_width (GTK_CONTAINER (text_sheet), 1);
	gtk_text_view_set_editable(GTK_TEXT_VIEW (text_sheet), FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW (text_sheet), FALSE);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (text_sheet), GTK_WRAP_WORD);
	gtk_widget_show (text_sheet);
	gtk_container_add (GTK_CONTAINER (scrolled_window), text_sheet);

	gtk_text_buffer_insert (entry_buffer, &iter, text_misc, -1);

	gtk_text_buffer_insert_with_tags_by_name (entry_buffer, &iter,
					    "Links\n\n", -1, 
					    "underline", "big", NULL);

	gtk_text_buffer_insert (entry_buffer, &iter, text_misc_links, -1);

	label = gtk_label_new (_("Misc"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox2, label);

	/*-----------------------------------------------------------------*/

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox2);

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolled_window);

	entry_buffer = gtk_text_buffer_new (NULL);
	gtk_text_buffer_get_iter_at_offset (entry_buffer, &iter, 0);
	gtk_text_buffer_create_tag (entry_buffer, "underline",
			      "underline", PANGO_UNDERLINE_SINGLE, NULL);
	gtk_text_buffer_create_tag (entry_buffer, "big",
			      "size", 12 * PANGO_SCALE, NULL);
	text_sheet = gtk_text_view_new_with_buffer (entry_buffer);
	gtk_container_set_border_width (GTK_CONTAINER (text_sheet), 1);
	gtk_text_view_set_editable(GTK_TEXT_VIEW (text_sheet), FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW (text_sheet), FALSE);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (text_sheet), GTK_WRAP_WORD);
	gtk_widget_show (text_sheet);
	gtk_container_add (GTK_CONTAINER (scrolled_window), text_sheet);

	gtk_text_buffer_insert (entry_buffer, &iter, text_license, -1);

	label = gtk_label_new (_("License"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox2, label);

	/*-----------------------------------------------------------------*/

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_show (hseparator1);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 6);

	hbuttonbox1 = gtk_hbutton_box_new ();
	gtk_widget_show (hbuttonbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, FALSE, TRUE, 4);

	close_button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
	gtk_widget_show (close_button);
	g_signal_connect (G_OBJECT (close_button), "clicked",
						G_CALLBACK (gui_about_window_close), NULL);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), close_button);
	GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);

	gtk_widget_grab_default (close_button);
}

