/*
 * Copyright (C) 2003 Hans Karlsson <karlsson.h@home.se>
 */


#include <kapplication.h>
#include <kfiledialog.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kconfig.h>

#include <qfileinfo.h>
#include <qstringlist.h>

#include "karamba.h"

//#include <ksgrd/SensorManager.h>
//#include <ksgrd/SensorAgent.h>
//#include <ksgrd/SensorAgent.h>
//#include <ksgrd/SensorManager.h>
//#include <ksgrd/StyleEngine.h>


static const char *description =
    I18N_NOOP("A KDE Eye-candy Application");

static const char *version = "0.17";

static KCmdLineOptions options[] =
    {
        //    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
        { "+file", I18N_NOOP("A required argument 'file'."), 0 },
        { 0, 0, 0 }

    };

int main(int argc, char **argv)
{
    KAboutData about("karamba", I18N_NOOP("karamba"), version, description,
                     KAboutData::License_GPL, "(C) 2003 Hans Karlsson", 0, 0, "karlsson.h@home.se");
    about.addAuthor( "Hans Karlsson", 0, "karlsson.h@home.se" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );

    KApplication app;
    karamba *mainWin = 0;

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    //KSGRD::SensorManager *f32 = new KSGRD::SensorManager();
    //f32->engage("localhost");
    //      KSGRD::SensorMgr  foo ;//  p->engage( "" );


    //KConfig *kconfig = KGlobal::config();
    //kconfig->setGroup("karamba");
    //kconfig->writeEntry("test", "/home/hk/foofoo");
    //kconfig->sync();


    bool OK = false;
    if(args->count() > 0)
    {
        for (int i = 0; i < (args->count()); i++)
        {
            if( args->arg(i) != "" )
            {
                QFileInfo file( args->arg(i) );
                //qDebug( file.dirPath(true) );
                if( file.exists() && !file.isDir() )
                {
                    //qDebug( "File exists" );
                    mainWin = new karamba( ( args->arg(i) ));
                    mainWin->show();
                    OK = true;
                }
            }
        }

        //app.setMainWidget( mainWin );
        int ret = 0;
        if( OK )
            ret = app.exec();
        return ret;
    }
    else
    {
        QStringList fileNames;
        fileNames = KFileDialog::getOpenFileNames(QString::null, "*.theme", 0, "Open configurations");
        for ( QStringList::Iterator it = fileNames.begin(); it != fileNames.end(); ++it )
        {
            QFileInfo file( *it );
            if( file.exists() && !file.isDir() )
            {
                mainWin = new karamba( *it );
                mainWin->show();
                OK = true;
            }
        }
        int ret = 0;
        if( OK )
            ret = app.exec();
        return ret;
    }

    args->clear();
    return 0;



}
