/***************************************************************************
                          ciconanimation.cpp  -  description
                             -------------------
    begin                : Tue Nov 15 17:03:53 CET 2005
    copyright            : (C) 2005 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "canimatedaction.h"

#include <kdebug.h>

CAnimatedAction::CAnimatedAction(const QString &text, const QString &pix, const KShortcut &cut, const QObject *receiver, const char *slot, KActionCollection *parent, const char *name):KAction (text, pix, cut, receiver, slot, parent, name)
{
  int i;
  const int begin=0;
  const int end=9;
  QString filename;
  
  currenticon=0;
  iconslist.clear();
  iconname=pix;
  for(i=begin;i<=end;i++)
  {
    filename=iconname+filename.sprintf("%.2d",i);
    iconslist.append(filename);
  }
  
  connect( &timericons, SIGNAL(timeout()), this, SLOT(slotDoAnimation()));
  connect(this, SIGNAL(enabled(bool)), SLOT(slotStartAnimation(bool)));
}


CAnimatedAction::~CAnimatedAction()
{
}


/** Prepare the animation of the icons, provided the toolbar is active*/
void CAnimatedAction::slotStartAnimation(bool isactive)
{
  if(isactive)
    timericons.start( 100, FALSE );
}


/** Start the animation of the icons*/
void CAnimatedAction::slotDoAnimation()
{
  if(currenticon>=iconslist.count())
  {
    timericons.stop();
    currenticon=0;
    setIcon(iconname);
    return;
  }
  setIcon(*iconslist.at(currenticon));
  currenticon++;
}

#include "canimatedaction.moc"
