/***************************************************************************
                          carj.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "carj.h"
#include <kdebug.h>
#include <qdir.h>

CArj::CArj(){
  CArchive();

  connect(&processread,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOut(KProcess*,char*,int)));
  connect(&processread,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processextract,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processextract,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processextract, SIGNAL(receivedStderr(KProcess *, char *, int)),this, SLOT(haveSdtErrExtract(KProcess*,char*,int)));
  connect(&processadd,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processadd,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));

  list->setColumnText(4, i18n("Owner"));
  list->setColumnText(5, i18n("Permissions"));
}

CArj::~CArj(){
}

/** this method will launch the right compressor
	to list the file contents
	It will then launch the right method to display
	the content in the listview */
void CArj::displayArchiveContent(){
	FILE *flot;

	initializeReadingArchive();

  processread << "arj";
	processread << "l" << archiveName;

  if(readArchiveWithStream)
  {
		processread.start(&flot,KProcess::AllOutput);
		displayArjArchiveContent(flot);
	}
	else
	{
		m_buffer[0]='\0';
		headerremoved=false;
		finished=false;
		processread.start(KProcess::NotifyOnExit, KProcess::AllOutput);
	}
}

/** display in a listview the content of the current
arj archive. This method examines the stdout of
unarj to sort useful infos for the listview */
void CArj::displayArjArchiveContent(FILE* flot){
	CListViewItem* elementListe;
	char tampon[5000];
	char permission[30];
	char owner[256];
	char crc[20];
	char size[30];
	char date[12];
	char hour[7];
	char sname[5000];
	QString path;
	QString name;
	QString message;
	int i;

	for(i=0;i<6;i++)
	{
		fgets( tampon, 5000, flot );
		sscanf(tampon,"%[^\n]",sname);
	}

	fgets( tampon, 5000, flot );

	while( !feof(flot) && (strstr( tampon, "------------" )==NULL))
	{
		sscanf(tampon, "%[a-zA-Z.0-9~] %[0-9] %[0-9] %[0-9.] %[0-9-] %[0-9:] %[^\n]", sname, size, permission, crc, date, hour, owner );

		name=sname;
		name=" "+name;
		i=name.findRev('/');
		if(i!=-1)
		{
			path=name.left(i+1);
		 	name=name.remove(0,i+1);
		if(name=="")
			name="..";
		}
		else
			path="";

		elementListe=new CListViewItem(list,name,size,hour,date,"","",path);
		setIcon(name, permission, elementListe);
		elementListe->widthChanged();
		fgets( tampon, 5000, flot );
	}
}

/*Overloaded method*/
void CArj::displayArjArchiveContent( const char* line){
	CListViewItem* elementListe;
	char permission[30];
	char owner[256];
	char crc[20];
	char size[30];
	char date[12];
	char hour[7];
	char sname[5000];
	QString path;
	QString name;
	QString message;
	int i;

		sscanf(line, "%[a-zA-Z.0-9~] %[0-9] %[0-9] %[0-9.] %8[0-9] %[0-9:] %[^\n]", sname, size, permission, crc, date, hour, owner );

		name=sname;
		i=name.findRev('/');
		if(i!=-1)
		{
			path=name.left(i+1);
		 	name=name.remove(0,i+1);
		if(name=="")
			name="..";
		}
		else
			path="";

		elementListe=new CListViewItem(list,name,size,hour,date,"","",path);
		setIcon(name, permission, elementListe);
		elementListe->widthChanged();
}

/** we recive some informations through the standard
output of the process */
void CArj::haveSdtOut(KProcess *, char *buffer, int length){
	//Has user canceled current action ?
	if(stopreadprocess)
		return;

	// This section is here only for testing. It has been taken from ark:
	//1997-1999: Rob Palmbos palm9744@kettering.edu
	//2000: Corel Corporation (author: Emily Ezust, emilye@corel.com)
	//and adapted to karchiveur
	int passage;
  char c = buffer[length];
  buffer[length] = '\0';

//  m_settings->appendShellOutputData( buffer );

  char line[1024] = "";
  char *tmpl = line;
  char *tmpb;


  //We copy m_buffer to tmpl
  for( tmpb = m_buffer; *tmpb != '\0'; tmpl++, tmpb++ )
    *tmpl = *tmpb;

  //We copy the fisrt string of buffer (till \n) to tmpl
  for( tmpb = buffer; *tmpb != '\n'; tmpl++, tmpb++ )
    *tmpl = *tmpb;

  tmpb++;
  *tmpl = '\0';

  if( *tmpb == '\0' )
    m_buffer[0]='\0';

/*	if((strncmp(line,"UNARJ",5)!=0)&&(line[0]!='\n'))
		displayArjArchiveContent( line );*/

  if( !strstr( line, "----" ) )
  {
		if( headerremoved && !finished )
	  	displayArjArchiveContent( line );
	}
  else if(!headerremoved)
    headerremoved = true;
  else
    finished = true;

  bool stop = (*tmpb == '\0');
  passage=0;

  while( !stop && !finished)
  {
      tmpl = line; *tmpl = '\0';

      for(; (*tmpb!='\n') && (*tmpb!='\0'); tmpl++, tmpb++)
				*tmpl = *tmpb;

      if( *tmpb == '\n' )
			{
			  *tmpl = '\n';
			  tmpl++;
			  *tmpl = '\0';
			  tmpb++;

  if( !strstr( line, "----" ) )
  {
		if( headerremoved && !finished )
	  	displayArjArchiveContent( line );
	}
  else if(!headerremoved)
    headerremoved = true;
  else
    finished = true;

	  	/*if((passage!=2)&&(strncmp(line,"-------- ",9)!=0)&&(strncmp(line," Length   Method",16)!=0))
	  		displayArjArchiveContent( line );
	  	else
	  		passage++;*/
			}
      else if (*tmpb == '\0' )
			{
	  		*tmpl = '\0';
			  strcpy( m_buffer, line );
	  		stop = true;
			}
    }
  buffer[length] = c;
}

/** we recive some informations through the standard
output of the process */
void CArj::haveSdtOutExtract(KProcess *, char *buffer, int length){
	QString inter;
	int i=0;

	inter=buffer;
	inter=inter.left(length);

	while((i=inter.find('\n',i+1))!=-1){
		progressbar->setProgress(progressbar->progress()+1);
	}
}

/** The current process ended */
void CArj::endProcess(KProcess*){
  kdDebug()<<("ARJ Process ENDED\n");
  emit(archiveReadEnded());
}

/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@toutextraire = 9: extract to karchiveur's temp directory (for viewing)
	*@toutextraire = 1: extract all selected files
	*/
void CArj::extractArchive(QString & extractpath, int extractall, QString & filetoextract){
 	QString directoryOption;
 	QString nameextrait;

        errors.clear();
	directoryOption="";
	counter=0;
	progressbar->reset();
	progressbar->setTotalSteps(list->childCount());

	QDir::setCurrent(extractpath);
	processextract.clearArguments();
	processextract << "arj";
	processextract << "e";
	if(!overwrite)
		processextract << "-f";

	processextract << archiveName;

 if((extractall!=EXTRACTONE)&&(extractall!=EXTRACTONE_AND_BLOCK)&&(!checkFiles(extractpath, extractall)))
 {
   endProcess(NULL);
   return;
 }
 else if(extractall==EXTRACTONE_AND_BLOCK)
 {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
   processextract << filetoextract;
   if(processextract.start(KProcess::Block)==FALSE)
     kdDebug()<<("\n*PB PROCESS*\n");
 }
 else if(extractall==EXTRACTONE)
 {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
   processextract << filetoextract;
   if(processextract.start(KProcess::NotifyOnExit)==FALSE)
     kdDebug()<<("\n*PB PROCESS*\n");
 }
 else if(extractall!=EXTRACTONE_AND_BLOCK)
 {
          //We extract through the Stdout to have a progress indicator
   if(processextract.start(KProcess::NotifyOnExit,KProcess::AllOutput)==FALSE)
     kdDebug()<<("\n*PB PROCESS*\n");
 }
 counter=0;
}

/** Add some files to the archive
@param filestoadd : list of files to add
@param removeoriginalfiles : remove or not those files from disk
@param action : 0=mode append and replace files, 1=mode update files
@param relativepath : if !NULL, include only filenames, without their base path */
void CArj::addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath){
  QString s;
  kdDebug()<<QString("RelativePath=%1").arg(relativepath)<<endl;
  if(relativepath!=NULL)
    QDir::setCurrent(relativepath);

  processadd.clearArguments();
  processadd << "arj";
  
  switch(action)
  {
    case UPDATE_FILES:
    {
      processadd << "f";
      break;
    }
    default:
    case ADD_AND_REPLACE_FILES:
    {
      processadd << "a";
      break;
    }
  }
  
  if(removeoriginalfiles)
    processadd << "m";
  if(recursivemode)
    processadd << "-r";

  
  processadd << QString("-m%1").arg((int)(compressrate*5.0/9.0));

  processadd << archiveName;
  for (QStringList::Iterator f = filestoadd.begin(); f!=filestoadd.end(); ++f )
  {
    s=*f;
    if( s.endsWith("/") )
      s.truncate(s.length()-1);
    if(s.startsWith("file:"))
      s.remove(0,5);
    kdDebug()<<QString("AddArj:%1 in %2").arg(s).arg(archiveName)<<endl;
    processadd << s;
  }
  processadd.start(KProcess::NotifyOnExit);
}

/** Create a zip archive
@param  nameofarchive: the name of the zip archive
@param param: list of files to add
@param relativepath: include only filenames, without their path */
void CArj::createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath) {
  QString str;

  archiveName=nameofarchive;
  kdDebug()<<QString("BeginCreationArj*%1*%2*").arg(nameofarchive).arg(relativepath)<<endl;
  addFilesToArchive(filestoadd, false, 0,relativepath);
}

#include "carj.moc"
