/***************************************************************************
                          cchoixfichier.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jun 3 1999                                           
    copyright            : (C) 1999 by Eric Coquelle                         
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kstandarddirs.h>
#include "cchoixfichier.h"

int CArchiveChoice::installedcompressors=0;

CArchiveChoice::CArchiveChoice(QWidget *parent, const char *name )
	: QWidget( parent, name )
{
  m_path=QDir::home();
  m_previouspath=QDir::home();
  kindofLastDirectory=1;
  filter="*.lha *.lzh *.arj *.rar *.gz *.bz2 *.zip *.jar *.tar *.tgz *.Z *.7z *.deb *.sit *.hqx|";
  filter+=i18n("All valid archives");
  filter+="\n*.lha.gpg *.lzh.gpg *.arj.gpg *.rar.gpg *.gz.gpg *.bz2.gpg *.zip.gpg *.jar.gpg *.tar.gpg *.tgz.gpg *.Z.gpg *.7z.gpg *.deb.gpg *.sit.gpg *.hqx.gpg|";
  filter+=i18n("All valid crypted archives");
  filter+="\n*.tar *.tar.gz *.tar.bz2 *.tgz *.Z|";
  filter+=i18n("tar archives");
  filter+="\n*.zip|";
  filter+=i18n("zip archives");
  filter+="\n*.rar|";
  filter+=i18n("rar archives");
  filter+="\n*.lha *.lzh|";
  filter+=i18n("lha archives");
  filter+="\n*.arj|";
  filter+=i18n("arj archives");
  filter+="\n*.gz|";
  filter+=i18n("gzip archives");
  filter+="\n*.bz2|";
  filter+=i18n("bzip2 archives");
  filter+="\n*.jar|";
  filter+=i18n("jar archives");
  filter+="\n*.7z|";
  filter+=i18n("7z archives");
  filter+="\n*.deb|";
  filter+=i18n("ar and deb archives");
  filter+="\n*.sit|";
  filter+=i18n("sit archives");
  filter+="\n*.hqx|";
  filter+=i18n("hqx archives");

  dlgbox=new KFileDialog(m_path.path(), filter, this,"", false);	
}

CArchiveChoice::~CArchiveChoice(){
}

void CArchiveChoice::initialise()
{
	uncompressor="";
	reader="";
	currentarchive="";
	kindofCompressor=-1; //No valid archive loaded
}

QString CArchiveChoice::openArchive()
{
	currentarchive=dlgbox->getOpenFileName(m_path.path(),filter);

	return currentarchive;
}


/** Finds which compressor is required to read currentarchive 
  * returns UNKNOWN if format is not supported, 0 otherwise */
int CArchiveChoice::findKindOfCompressor()
{
  QString archive;

  if(currentarchive.isNull())
    return UNKNOWN;

  archive=currentarchive.lower();

  nameofCompressor="tar";
  kindofCompressor=UNKNOWN;
  optionSupp="";
  compressandconcatenate="";
  compressoravaible=false;

      if((archive.right(7)==".tar.gz")||(archive.right(6)==".tar.z")||(archive.right(4)==".tgz")||(archive.right(7)=="_tar.gz")||(archive.right(6)=="_tar.z")||(archive.right(4)=="_tgz"))
      {
                     uncompressor="-zvxf";
                     reader="-zvtf";
                     compressandconcatenate="-r";
                     kindofCompressor=TARGZ;
      }
      else if((archive.right(8)==".tar.bz2")||(archive.right(8)=="_tar.bz2"))
      {
                     optionSupp="--use-compress-program=bzip2";
                     uncompressor="-vxf";
                     reader="-vtf";
                     kindofCompressor=TARBZ2;
      }
      else if((archive.right(4)==".zip")||(archive.right(4)==".jar"))
      {
                     nameofCompressor="unzip";
                     reader="-lv";
                     uncompressor="";
                     kindofCompressor=ZIP;
      }
      else if((archive.right(4)==".tar")||(archive.right(4)=="_tar"))
      {
               reader="-vtf";
               uncompressor="-vxf";
               kindofCompressor=TAR;
      }
      else if(archive.right(3)==".gz")
      {
               nameofCompressor="gzip";
               reader="-lv";
               uncompressor="-dv";
               kindofCompressor=GZIP;
      }
      else if(archive.right(4)==".bz2")
      {
               nameofCompressor="bzip2";
               reader="";
               uncompressor="-dvk";
               kindofCompressor=BZIP2;
      }
      else if(archive.right(4)==".rar")
      {
               nameofCompressor="unrar";
               reader="l";
               uncompressor="x";
               kindofCompressor=RAR;
      }
      else if((archive.right(4)==".lzh")||(archive.right(4)==".lha"))
      {
               nameofCompressor="lha";
               reader="l";
               uncompressor="x";
               kindofCompressor=LHA;
      }
      else if(archive.right(4)==".arj")
      {
               nameofCompressor="unarj";
               reader="l";
               uncompressor="e";
               kindofCompressor=ARJ;
      }
      else if(archive.right(4)==".gpg")
      {
               kindofCompressor=CRYPTED;
      }
    else if(archive.right(3)==".7z")
    {
        nameofCompressor="7za";
        reader="l";
        uncompressor="e";
        kindofCompressor=SEVENZ;
    }
    else if(archive.right(4)==".deb")
    {
        nameofCompressor="ar";
        reader="t";
        uncompressor="e";
        kindofCompressor=AR;
    }
    else if(archive.right(4)==".sit")
    {
      nameofCompressor="unstuff";
      reader="";
      uncompressor="";
      kindofCompressor=SIT;
    }
    else if(archive.right(4)==".hqx")
    {
      nameofCompressor="unstuff";
      reader="";
      uncompressor="";
      kindofCompressor=HQX;
    }
    else
      return UNKNOWN;

  compressoravaible=getInstalledCompressors() & kindofCompressor;
  //As the archive is valid, we set the last open directory
  m_previouspath=currentarchive.left(currentarchive.findRev('/'));
  if(kindofLastDirectory==0)
  	m_path=m_previouspath;
  return 0;
}

/** check which compressors are available */
int CArchiveChoice::getInstalledCompressors(){
  installedcompressors=0;
  if(KStandardDirs::findExe("tar")!=NULL)
    installedcompressors=installedcompressors|TAR;
  if(KStandardDirs::findExe("gzip")!=NULL)
    installedcompressors=installedcompressors|GZIP;
  if(KStandardDirs::findExe("bzip2")!=NULL)
    installedcompressors=installedcompressors|BZIP2;
  if(installedcompressors & (TAR | GZIP))
   installedcompressors=installedcompressors|TARGZ;
  if(installedcompressors & (TAR | BZIP2))
   installedcompressors=installedcompressors|TARBZ2;
  if(KStandardDirs::findExe("lha")!=NULL)
    installedcompressors=installedcompressors|LHA;
  if(KStandardDirs::findExe("rar")!=NULL)
    installedcompressors=installedcompressors|RAR;
  if(KStandardDirs::findExe("unzip")!=NULL)
    installedcompressors=installedcompressors|ZIP;
  if(KStandardDirs::findExe("unarj")!=NULL)
    installedcompressors=installedcompressors|ARJ;
  if(KStandardDirs::findExe("7za")!=NULL)
    installedcompressors=installedcompressors|SEVENZ;
  if(KStandardDirs::findExe("ar")!=NULL)
    installedcompressors=installedcompressors|AR;
  if(KStandardDirs::findExe("unstuff")!=NULL)
    installedcompressors=installedcompressors|SIT;

  return installedcompressors;
}

QString CArchiveChoice::getCompresseur()
{
  return compresseur;
}

QString CArchiveChoice::getUncompressor()
{
	return uncompressor;
}

QString CArchiveChoice::getReader()
{
	return reader;
}

QString CArchiveChoice::getArchiveName()
{
	return currentarchive;
}

QString CArchiveChoice::getProgrCompresseur()
{
	return nameofCompressor;
}

QString CArchiveChoice::getOptionSupp()
{
	return optionSupp;
}

QString CArchiveChoice::getConcateneur()
{
	return compressandconcatenate;
}

void CArchiveChoice::setArchiveName(QString archive)
{
  currentarchive=archive;
}

/** Set the acess path when opening an archive */
void CArchiveChoice::setFullPath(QString  path){
	m_path=path;
	if(!m_path.isReadable())
		m_path=QDir::home();
}

/** return the directory's path of the opened file */
QString CArchiveChoice::getAccessPath(){
	return m_path.path();
}

/** Define the default path when opening a file
0: Last dir
1: home dir
2: shell's one */
void CArchiveChoice::setFullPath(QString path, int optionOpening){
	kindofLastDirectory=optionOpening;
	m_path=path;
	
	switch(optionOpening)
	{
		case 0:
			setFullPath(path);
			break;
		case 1:
			m_path=QDir::home();
			break;
		case 2:
			m_path.setPath("");
			break;
	}
}

/** returns the exact compressor type */
int CArchiveChoice::getKindOfCompressor(){
	return kindofCompressor;
}

/** Define the default path when opening a file
0: Last dir
1: home dir
2: shell's one */
void CArchiveChoice::setOptionOpening(int optionOpening){
	kindofLastDirectory=optionOpening;
	switch(optionOpening)
	{
		case 0:
			m_path=m_previouspath;
		case 1:
			m_path=QDir::home();
			break;
		case 2:
			m_path.setPath("");
			break;
	}
}

/** return the directory of the current archive */
QString CArchiveChoice::getCurrentArchiveDirectory(){
  return m_previouspath.path();
}

/** We store somewhere an oldpath variable,
    used to know what is the last open dir */
void CArchiveChoice::setForInitPreviousPath( QString path ){
  m_previouspath=path;
  if(!m_previouspath.isReadable())
    m_previouspath=QDir::home();
}

/** Return true if the compressor that'll be used is installed on disk */
bool CArchiveChoice::isCurrentCompressorAvaible(){
	return compressoravaible;
}

#include "cchoixfichier.moc"
