/***************************************************************************
                          cproprietes.cpp  -  description
                             -------------------
    begin                : Sun Jul 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "cproprietes.h"

#include <qfont.h>
#include <qlayout.h>

#include <klocale.h>


CProprietes::CProprietes(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	
	//Aditionnal init
	setCaption(i18n("Properties"));
	
	connect(QPushButton_1,SIGNAL(clicked()), SLOT(accept()) );
}

CProprietes::~CProprietes(){
}

void  CProprietes::initDialog(){
  
  QGridLayout* layout=new QGridLayout(this, 5, 2, 12);
  
  QLabel* QLabel_1= new QLabel(this,"NoName");
  QLabel_1->setText(i18n("The file:"));
  layout->addMultiCellWidget(QLabel_1, 0, 0, 0, 1);

  lfilename= new QLabel(this,"NoName");
  lfilename->setFont(QFont("helvetica", 12, 75,true));
  layout->addMultiCellWidget(lfilename, 1, 1, 0, 1);

  
  QLabel* QLabel_3= new QLabel(this,"NoName");
  QLabel_3->setText(i18n("Will be extracted in:"));
  layout->addWidget(QLabel_3, 0, 2);

  lPath= new QLabel(this,"NoName");
  lPath->setFont(QFont("helvetica", 12, 75,true));
  layout->addWidget(lPath, 1, 2);

  
  QLabel* QLabel_4= new QLabel(this,"NoName");
  QLabel_4->setText(i18n("It will occupy:"));
  layout->addMultiCellWidget(QLabel_4, 2, 2, 0, 1);

  lSize= new QLabel(this,"NoName");
  lSize->setFont(QFont("helvetica", 12, 75,true));
  lSize->setAlignment(Qt::AlignRight);
  layout->addWidget(lSize, 3, 0);

  QLabel* QLabel_9= new QLabel(this,"NoName");
  QLabel_9->setText(i18n("bytes on disk"));
  layout->addWidget(QLabel_9, 3, 1);

  
  lPermissiontxt= new QLabel(this,"NoName");
  lPermissiontxt->setText(i18n("It has these permissions:"));
  layout->addMultiCellWidget(lPermissiontxt, 4, 4, 0,  1);
  
  lPermission= new QLabel(this,"NoName");
  lPermission->setFont(QFont("helvetica", 12, 75,true));
  layout->addMultiCellWidget(lPermission, 5, 5, 0,  1);

  lPermissiontxt->setEnabled(false);
  lPermission->setEnabled(false);

  QPushButton_1= new QPushButton(this,"NoName");
  QPushButton_1->setText(i18n("OK"));
  layout->addMultiCellWidget(QPushButton_1, 4, 5, 2,  2);
}

/** set the path to be displayed of selected
item in the listview */
void CProprietes::setFilePath( QString path ){
  if(path.startsWith("/"))
    path.remove(0,1);
  lPath->setText(path);
}

/** set the name of the selected file */
void CProprietes::setFileName( QString name ){
  lfilename->setText(name);
}

/** set the permissions of the selected file */
void CProprietes::setPermission( QString perm ){
  lPermissiontxt->setEnabled(true);
  lPermission->setEnabled(true);
  lPermission->setText(perm);
}

/** set the size which the selected file will
occupy on disk */
void CProprietes::setSize( QString size ){
  lSize->setText(size);
}

#include "cproprietes.moc"
