/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) YEAR by AUTHOR
    email                : EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "cscript.h"

CScript::CScript()
{
}

CScript::~CScript()
{
}

/* Start the wizard operations)*/
int CScript::startWizard(QString cfichselect, QString crepbase, QString nomarch)
{
	fichselect=cfichselect;
	repbase=crepbase;
	archivename=nomarch;
	return mainwizardpage();
}

/** show the first wizard */
int CScript::mainwizardpage()
{
	while(wizmainpage.exec() != QDialog::Rejected)
	{
		if(wizmainpage.getTypeOperation()==0)
		{
			//It's a patch
            CWizardStep1Patch oppatch;    
            if(oppatch.exec())
            {
              CWizardStep3 objAssistTrois;
              objAssistTrois.fichselect=fichselect;
              objAssistTrois.basedir=repbase;
              objAssistTrois.setOperation(0);
              objAssistTrois.exec();
              return WIZ_PATCH;
           }         
		}
		else if(wizmainpage.getTypeOperation()==1)
		{
			 //It's an installation
			CWizardInstallation opinstal;
            if( opinstal.exec() == QDialog::Accepted )
            {
              CWizardStep3 objAssistTrois;
              objAssistTrois.fichselect=fichselect;
              objAssistTrois.basedir=repbase;
              objAssistTrois.setOperation(1);
              objAssistTrois.setParametres(opinstal.getConfigure(),
                                            opinstal.getArguments(),
                                            opinstal.getMake(),
                                            opinstal.getMakeInstall(),
                                            opinstal.getTypeInstall());
                objAssistTrois.exec();
                
                return WIZ_INSTALLATION;
            }
            
		}
		else if(wizmainpage.getTypeOperation()==2)
		{
			//It's a conversion
            CWizardConversion opconversion;
            if( opconversion.exec() == QDialog::Accepted )
            {
              targetdirectoryconversion =  opconversion.getConversionTargetDirectory();
              targettypeconversion = opconversion.getNewArchiveType();
              return WIZ_CONVERSION;
            }
		}
		else if(wizmainpage.getTypeOperation()==3)
		{
			//It's a split
            CWizardCutt opcutt;
            if(opcutt.exec() == QDialog::Accepted )
            {
              cuttsize=opcutt.getCuttSize();
              targetdirectorycutt = opcutt.getRecordDirectory();
              return WIZ_UNCUTT;
            }
		}
  else if(wizmainpage.getTypeOperation()==4)
  {
			//It's a sfx
    CWizardSfx opsfx;
    if(opsfx.exec() == QDialog::Accepted )
    {
      sfxtype=opsfx.getSfxType();
      sfxname=opsfx.getSfxName();
      return WIZ_SFX;
    }
  }
 }
	return -1;
}

/** return the conversion format */
int CScript::getTypeConversion()
{
	return targettypeconversion;
}

/** Return the directory where to store the
converted archive */
QString CScript::getDirectoryConversion()
{
	return targetdirectoryconversion;
}

/* Return the directory or file for cutt/uncutt operations.
Needs to probe a .01 extension */
QString CScript::getDirectoryCutt()
{
	return targetdirectorycutt;
}

/** Return the size of a block of a huge file */
int CScript::getCuttSize()
{
	return cuttsize;
}
