/***************************************************************************
                          cutt.h  -  description
                          Cuts a big file in a series of smaller ones
                             -------------------                                         
    begin                : 02/20/2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef __CUTT_H__
#define __CUTT_H__

#include <kapp.h>
#include <qfile.h>
#include <qstring.h>

#define buffersize 50000

/**
 *@author Eric Coquelle
 */

class cuttFichier
{
  public:
  cuttFichier();
  ~cuttFichier();
  /* split the archive in Nbr parts, of T bytes, the ending block  of Tb bytes */
  void Cut(const unsigned int Nbr, const long T, const long Tb, QString target);
  /* Unsplit the archive */
  int uncut(QString splitArchiveName, QString directory);
  /* Start the operations on archiveName. Split it if operation=0, else unsplit it*/
  int Begin(QString archiveName, int operation, QString directory,  int blocksize=1450000);

  public:
    enum operation {SPLIT=0, UNSPLIT};
    enum result {CUTT_OK, CUTT_ERROR};
    
private:
  char  buffer[buffersize];
  QFile input;
};

#endif
