/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cwizardinstallation.h"

#include <unistd.h>
#include <kapplication.h>
#include <klocale.h>
#include <kstddirs.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qdir.h>


CWizardInstallation::CWizardInstallation(QWidget *parent, const char *name) : KWizard(parent,name){
  setupPageOne();
  setupPageTwo();
  setupPageThree();

  this->setCaption(i18n("Installation wizard"));
  slotActiveInstall(0);
        
    connect(QButtonGroup_1, SIGNAL(clicked(int)), SLOT(slotActiveInstall(int)));  
}

CWizardInstallation::~CWizardInstallation(){
}

void  CWizardInstallation::setupPageOne(){
  
  QWidget* pageone = new QWidget(this);
  
  QGridLayout* layout=new QGridLayout(pageone, 10, 2, 8);

  QLabel* QLabel_1= new QLabel(pageone,"NoName");
  QLabel_1->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(QLabel_1, 0, 7, 0, 0);

  QLabel* QLabel_2= new QLabel(pageone,"NoName");
  QLabel_2->setText("<qt><h1>"+i18n("Install software")+"</h1></qt>");
  layout->addWidget(QLabel_2, 0, 1);


  QLabel* QLabel_3= new QLabel(pageone,"NoName");
  QLabel_3->setText("<qt><p>"+
                      i18n("Most GNU softwares have to be compiled before you can use then. Hopefully, you don't have to worry about it.")
                      +"</p><p>"
                      +i18n("Just click on next, leave the input fields unchanged (unless you know what you are doing), and KArchiver will install this software for you. Please note that you may be prompted for your 'root' password to finish the installation.")
                      +"</p></qt>");
  layout->addMultiCellWidget(QLabel_3, 1,7, 1, 1);

  addPage(pageone, i18n("KArchiver installation wizard - step 1"));
  setHelpEnabled(pageone, false);
}

void  CWizardInstallation::setupPageTwo()
{
  QWidget* pagetwo = new QWidget(this);
  QGridLayout* layout=new QGridLayout(pagetwo, 10, 2, 8);

  labelwizard2i= new QLabel(pagetwo,"NoName");
  labelwizard2i->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(labelwizard2i, 0, 7, 0, 0);

  QLabel* QLabel_2= new QLabel(pagetwo,"NoName");
  QLabel_2->setText("<qt><h1>"+i18n("Installing software")+"</h1></qt>");
  layout->addMultiCellWidget(QLabel_2, 0, 0, 1, 2);

  QLabel* QLabel_3= new QLabel(pagetwo,"NoName");
  QLabel_3->setText(i18n("You are now ready to start install."));
  layout->addMultiCellWidget(QLabel_3, 2, 2, 1, 2);

  QString directory;
  QString tmpdir = locateLocal( "tmp", directory );
  directory.sprintf("karchivertmp.%d/extract/", getpid());
  
  QLabel* QLabel_4= new QLabel(pagetwo,"NoName");
  QLabel_4->setText("<qt><p>"
                    +i18n("Take a look at the output window to ensure that everything is OK (the errors appear in red). Don't forget you have to be 'root' to install this software.")
                    +"</p><p>"
                    +i18n("Perhaps you only wish to compile it using the wizard, and <i>before</i> leaving it, jump back to the console. Or you can install it in your home folder, but in this case, don't forget to provide this option:")
                    +"<i> --prefix="+QDir::homeDirPath()+"</i>"
                    +"</p><p>"
                    +i18n("As long as the wizard remains active, the compiled files stay stored in")
                    +"<i> "+tmpdir+directory+"</i>"
                    +"</qt>");
  layout->addMultiCellWidget(QLabel_4, 3, 3, 1, 2);

  addPage(pagetwo, i18n("KArchiver installation wizard - step 2"));
  setHelpEnabled(pagetwo, false);
}

void CWizardInstallation::setupPageThree()
{
  QWidget* pagethree = new QWidget(this);
  QGridLayout* layout=new QGridLayout(pagethree, 8, 3, 8);

  label2_0= new QLabel(pagethree,"NoName");
  label2_0->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(label2_0, 0, 5, 0, 0);

  label2_1= new QLabel(pagethree,"NoName");
  QToolTip::add(label2_1,i18n("the configure script\nShould not be changed"));
  label2_1->setText(i18n("First run:"));
  layout->addWidget(label2_1, 0, 1);

  leconfigure= new QLineEdit(pagethree,"lineEditConfigure");
  leconfigure->setText("configure");
  layout->addWidget(leconfigure, 1, 1);

  label2_2= new QLabel(pagethree,"NoName");
  label2_2->setText(i18n("With the following arguments:"));
  QToolTip::add(label2_2,i18n("For example: --prefix=/usr\nShould work fine with default arguments"));
  layout->addWidget(label2_2, 2, 1);

  learguments= new QLineEdit(pagethree,"lineEditArguments");
  layout->addWidget(learguments, 3, 1);

  label2_3= new QLabel(pagethree,"NoName");
  label2_3->setText(i18n("Then"));
  layout->addWidget(label2_3, 4, 1);

  lemake= new QLineEdit(pagethree,"lineEditMake");
  lemake->setText("make");
  layout->addWidget(lemake, 5, 1);

  QGroupBox_2= new QGroupBox(pagethree,"NoName");
  QGroupBox_2->setTitle(i18n("Installation"));
  layout->addMultiCellWidget(QGroupBox_2, 6, 7, 0, 1);
  QGridLayout* vgrid=new QGridLayout(QGroupBox_2, 2, 2, 20, 16);

  QButtonGroup_1= new QButtonGroup(QGroupBox_2,"NoName");
  QButtonGroup_1->setTitle(i18n("I Will Install"));
  vgrid->addMultiCellWidget(QButtonGroup_1, 0, 0, 0, 1);
  QHBoxLayout* hbox=new QHBoxLayout(QButtonGroup_1, 20, 16);

      radioroot= new QRadioButton(QButtonGroup_1,"NoName");
      radioroot->setText(i18n("As root"));
      radioroot->setChecked(true);
      hbox->addWidget(radioroot);

      radiouser= new QRadioButton(QButtonGroup_1,"NoName");
      radiouser->setText(i18n("As current user"));
      hbox->addWidget(radiouser);

      radiopasinstall= new QRadioButton(QButtonGroup_1,"NoName");
      radiopasinstall->setText(i18n("Don't install"));
      hbox->addWidget(radiopasinstall);

  label2_4= new QLabel(QGroupBox_2,"NoName");
  label2_4->setText(i18n("and I will run make"));
  vgrid->addWidget(label2_4, 1, 0);

  lemakeinstall= new QLineEdit(QGroupBox_2,"NoName");
  lemakeinstall->setEnabled(false);
  lemakeinstall->setText("install");
  vgrid->addWidget(lemakeinstall, 1, 1);

  addPage(pagethree, i18n("KArchiver installation wizard - step 3"));
  setHelpEnabled(pagethree, false);
  setFinishEnabled(pagethree, true);
}

/** the user can su root, so we can make install */
void CWizardInstallation::slotActiveInstall(int valeur)
{
    typeInstall=valeur;
    
    if(valeur<2)
    {   
        lemakeinstall->setEnabled(true);
        label2_4->setEnabled(true);
    }
    else
    {   
        lemakeinstall->setEnabled(false);
        label2_4->setEnabled(false);
    }   
}

#include "cwizardinstallation.moc"
