/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cwizardmainpage.h"

#include <qlayout.h>
#include <qlabel.h>


CWizardMainPage::CWizardMainPage(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	
	//Additionnal init
	setCaption(i18n("KArchiver wizard step 1"));
	
	connect(buttoncancel, SIGNAL(clicked()), SLOT(reject()));
	connect(buttongo, SIGNAL(clicked()), SLOT(accept()));	
}

CWizardMainPage::~CWizardMainPage(){
}

/*Wizard main page*/
void  CWizardMainPage::initDialog(){
  QGridLayout* layout=new QGridLayout(this, 9, 3, 8, 12, "LayoutIntroPage");
  
  QLabel* QLabel_Wiz= new QLabel(this,"WizardPicture");
  QLabel_Wiz->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(QLabel_Wiz, 0, 5, 0, 0);

  
  QLabel* labeltext1= new QLabel(this,"IntroPageText");
  labeltext1->setText("<qt><b>"+
      i18n("This Wizard will help you to make some usefull things with your archive:")
      +"</b><ul><li>"
      +i18n("Convert the format of this archive (make a .zip from a .tar.gz)")
      +"</li><li>"
      +i18n("Install the software contained in this archive: configure graphically, make, and make install (as root) in 3 mouse clics") +"</li><li>"
      +i18n("Split a huge archive in small block (to fit in a floppy or in a mail)")
      +"</li><li>"
      +i18n("This file contains a patch, so apply it to a taget folder")
      +"</li></ul></qt>");
  layout->addMultiCellWidget(labeltext1, 0, 5, 1, 2);
  

  buttongo= new QPushButton(this,"buttonGo");
  buttongo->setText(i18n("&Next >>"));
  layout->addWidget(buttongo, 7, 2);

  buttoncancel= new QPushButton(this,"buttonCancel");
  buttoncancel->setText(i18n("&Cancel"));
  layout->addWidget(buttoncancel, 8, 2);

  QButtonGroup_1= new QButtonGroup(this,"bgactionchoice");
  QButtonGroup_1->setTitle(i18n("Time to Choose"));
  layout->addMultiCellWidget(QButtonGroup_1, 6, 8, 0, 1);
  QVBoxLayout* vbox=new QVBoxLayout(QButtonGroup_1, 18);
  
  radioconvert= new QRadioButton(QButtonGroup_1,"radioConvert");
  radioconvert->setText(i18n("Convert the &format of this archive"));
  vbox->addWidget(radioconvert);
  
  radioinstall= new QRadioButton(QButtonGroup_1,"radioInstall");
  radioinstall->setText(i18n("Install the software contained in this archive"));
  radioinstall->setChecked(true);
  vbox->addWidget(radioinstall);
  
  radiopatch= new QRadioButton(QButtonGroup_1,"radioPatch");
  radiopatch->setText(i18n("Apply a patch"));
  vbox->addWidget(radiopatch);

  radiosplit= new QRadioButton(QButtonGroup_1,"radioSplit");
  radiosplit->setText(i18n("Split this archive"));
  vbox->addWidget(radiosplit);

  radiosfx= new QRadioButton(QButtonGroup_1,"radioSfx");
  radiosfx->setText(i18n("Create a Sfx archive"));
  vbox->addWidget(radiosfx);

}

/** get wether it's a patch or an install wizard */
int CWizardMainPage::getTypeOperation()
{
  if(radiopatch->isChecked())
          return 0;
  else if(radioinstall->isChecked())
          return 1;
  else if(radioconvert->isChecked())
          return 2;
  else if(radiosplit->isChecked())
    return 3;
  else if(radiosfx->isChecked())
    return 4;
  return -1;
}

#include "cwizardmainpage.moc"
