/***************************************************************************
                          karchiveur.h  -  description
                             -------------------
    begin                : mer jun 14 00:26:31 CEST 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KARCHIVEUR_H
#define KARCHIVEUR_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qstrlist.h>
#include <qlistview.h>
#include <qiconset.h>
#include <qcolor.h>
#include <qdragobject.h>
#include <qclipboard.h>

// include files for KDE 
#include <kapplication.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kled.h>
#include <qprogressbar.h>
#include <kmessagebox.h>
#include <kurl.h>
#include <kio/netaccess.h>
#include <kaboutdialog.h>
#include <kaction.h>
#include <kstatusbar.h>

//Other includes
#include "cchoixfichier.h"
#include "processus.h"
#include "cextraction.h"
#include "caddfilestoarchive.h"
#include "cled.h"
#include "cnavigateur.h"
#include "cinfos.h"
#include "crecherche.h"
#include "cutt.h"
#include "cscript.h"
#include "cpreferences.h"
#include "cproprietes.h"
#include "cfind.h"
#include "ktipofday.h"
#include "caddfiles.h"
#include "carchive.h"
#include "ctar.h"
#include "ctargz.h"
#include "ctarbz2.h"
#include "carj.h"
#include "clha.h"
#include "crar.h"
#include "czip.h"
#include "cgz.h"
#include "cbz2.h"
#include "cfirstinstallwizard.h"
#include "canimatedaction.h"
#include "carchiveoperation.h"
#include "canimation.h"

//Some definitions
#define LIGNECOMMANDE    -2
#define NOARCHIVE        -1
#define STANDBY           0
#define READING           1
#define EXTRACTING        2
#define DEPLACEMENT       3
#define ADDING            4
#define ADDCREATE         5
#define VISUALISATION     6
#define TAILLEARCHIVE     7
#define CONVERSION        8
#define SCRIPT            9
#define TESTING          10
#define MAKESFX          11
#define ARCHIVEOPERATION 12

// forward declaration of the Karchiveur classes
class KarchiveurView;

/**
  * The base class for Karchiveur application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KarchiveurView creates your center view, which is connected
  * to the window's Doc object.
  * KarchiveurApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */
class KarchiveurApp : public KMainWindow
{
  Q_OBJECT

  friend class KarchiveurView;

  public:
    /** construtor of KarchiveurApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    KarchiveurApp();
    ~KarchiveurApp();
  /** this method will launch the right compressor
		* to list the file contents
		* It will then launch the right method to display
		* the content in the listview */
  void displayArchiveContent();
  /** return the size in bytes of the current archive */
  int archiveSize(const QString &);
  /** Add some files to the archive
    * @param listfilestoadd : list of files to add
    * @param removefiles : remove or not those files from disk
    * @param actionfichiers : 0=mode append and replace files, 1=mode update files
    * @param relativePath : include only filenames, without their path */
  void addToArchive( QStringList , bool , int, QString);
  /** Remove the files @param filesToDelete from archive archive */
  void removeFilesFromArchive(const QString  &archive, QStringList filesToDelete);
  /** Download a net file and returns itls local filename */
  QString openRemoteFile( const KURL& url);
  /** Displays in the status bar the size of the archive */
  void displayMessageArchiveSize();
  /** Open the archive nomArchive, which was sent
   *by the command line */
  void openFileFromCommandLine(QStringList);
  /** Extract the archives @archives to the directory @extractdir.
    If @promptdir is true, we'll show the extract dialog, to let the user
    choosing its extract dir */
  void extractFromCommandLine( QStringList archives, bool promptdir=false, QCString extractdir=NULL, bool chooseExtractDirFromArchive=false );
  /** Automaticaly create a compressed file containing @files.
  If there is a single file or directory, create an archive
  named files.preferedtype, delault compressor set by preferedtype.
  Otherwise, prompt the user for a name */
  void createArchiveFromCommandLine( QStringList files, QString preferedtype=NULL );
  /** crypt current archive */
  void cryptArchive();
  /** displays the configuration wizard(if 1st launch & bool=true) and the tip of the day*/
  void configurationWizardAndTip( bool );

  protected:
    /* This method will convert the archive format */
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);
  /** A drop will occur, so we have to allow it */
  void dragEnterEvent(QDragEnterEvent* e);
  /** someone has dropped something ! */
  void dropEvent( QDropEvent *drop);
  /** Some files were dropped or pasted; they have
		* been decoded in strliste, so just open them !
		*/
  void openFilesDropPaste( QStringList strliste );
  /** Initialize the actions and the GUI */
  void initActions();
  /** Check wether karchiver is lauched for the first time. If so, launch
      a wizard to configure the main features */
  void checkFirstInstall();
  /** enable or disable the KAction menus */
  void enableMenus(bool b);
  /** return true if KIO supports current kind of archive */
  bool supportDisplayByDirs();
  virtual void keyPressEvent ( QKeyEvent * e );
  virtual void keyReleaseEvent ( QKeyEvent * e );

  public slots:
    /** open a new application window by creating a new instance of KarchiveurApp */
    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(int id_);
    void slotFileOpenRecent(const KURL& url);
    /** Convert archive type*/
    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window*/
    void slotFileClose();
    /** print the actual file */
    void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label temporary, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
  /** Split/Unsplit the archive in/from small parts */
  void slotDiskCutUncut();
  /** allow user to set the options */
  void slotSetOptions();
  /** display some infos about the current archive */
  void slotDisplayArchiveInfos();
  /** remove from archive all selected files */
  void slotRemoveSelectedFiles();
  /** display all selected files */
  void slotDisplaySelectedFiles();
  /** display a file using its associated program */
  void slotDisplayFile();
  /** add some files to the archive */
  void slotAddFiles();
  /** Make all or some files to be extracted */
  void slotExtractArchive();
  /** displays a window and search recursively 
		* for archives in a directory */
  void slotFileSearch();
  /* Hide the archive browser */
  void slotHideButineur();
  /** display or not the archive browser */
  void slotViewButineur();
  /** Launch the wizard */
  void slotWizard();
  /** we recive some informations through the standard output of the process */
  void recueSdtOut(KProcess*,char*,int);
  /** Open the archive @param archivename, which was selected from the archive browser */
  void slotOpenFileFromArchiveBrowser(const QString& archivename);
  /** Open the archive @param nomArchive, which was found
		* using the search tool */
  void slotOpenFileFromArchiveFinder(const QString& nameArchive);
  /** Receive a message when the user try to
		* drag something. It extract the selected files,
		* and then transmit their path to the target
		* application
		*/
  void slotDoDragAndDrop();

protected slots: // Protected slots
  /** The contextual menu has been activated */
  void slotContextualMenuActivated(int);
  /** The user right-clicked on a file in the listview,
		* so we'll display a contextual menu */
  void slotShowContextualMenu ( QListViewItem *, const QPoint &, int );
  /** The mouse button was clicked on the listview */
  void slotMouseClick(QListViewItem*);
  /** The user selected paste */
  void slotPaste();
  /** The user try to copy a karchiveur's file to
the clipboard */
  void slotCopy();
  /** extract the selected files to trash and then
remove them from the archive */
  void slotRemoveToTrashSelectedFiles();
  /** the user has "cutted" some files in the current
archive */
  void slotCutt();
  /** find in this archive all items matching the
name name */
  void slotFindInThisArchive( QString name );
  /** unselect all files in the current archive */
  void slotUnselectAll();
  /** select all the files in the current archive */
  void slotSelectAll();
  /** Use the find in this archive tool */
  void slotUseFind();
  /** the user closed the find in this archive tool */
  void slotCloseFind();
  /** Undo the previous operation, i.e. the deletion
od files from archive */
  void slotUndo();
  /** Remove form current archive the selected fies,
with an undo option (i.e. extract to repundo, then
remove) */
  void slotRemoveWithUndoSelectedFiles();
  void slotSetPassword();
  /** Redo the last operation (i.e. remove once
again the selected file) */
  void slotRedo();
  /** Remove the @param files from current archive */
  void slotRemoveThoseFiles( QStringList files );
  /** Remove from current archives the files in
files, with undo possibility */
  void slotRemoveWithUndoThoseFiles( QStringList files );
  /** a process in Carchive has ended. So make
the necessary with the operation variable */
  void slotEndProcess();
  /** Display in a dialog box some informations
		* concerning the selected file */
  void slotDisplayFileProprieties();

  void slotEditToolbars();
  /** crypt current archive using gpg */
  void slotCryptArchive();
  /*Mail current archive */
  void slotMailArchive();
  /*Retrieves the ChangeLog and check if karchiver is up to date*/
  void slotCheckUpdate();
  /** Test the archive for errors*/
  void slotTestArchive();
  /** Scan archive for viruses */
  void slotScanArchive();
  /** User wants to go to a subfolder */
  void slotComboDirectoriesActivated(int);
  /** Extract all files to a temp dir, and add them to the
  karchiver's sfx module */
  void slotMakeSfxArchive();
  /** Messages from CArchiveOperation and childs */
  void slotMessageArchiveOperation(int , QString );
  /** Ask if KArchiver has to compile this autoconf-based archived software */
  void slotAskForCompilation();
  
  private:
    /** contains the recently used filenames */
    QStrList recentFiles;
    /** the configuration object of the application */
    KConfig *config;
    /** the key accelerator container */
    KAccel *keyAccel;
    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** the recent file menu containing the last five opened files */
    QPopupMenu *recentFilesMenu;
    /** archive_menu contains all items of the menubar entry "Archive" */
    QPopupMenu *archiveMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** disk_menu contains all items of the menubar entry "Disk" */
    QPopupMenu *diskMenu;
    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** help_menu contains all items of the menubar entry "Help" */
    KHelpMenu *helpMenu_;
    /* The contextual menu*/
    QPopupMenu *contextualMenu;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    KarchiveurView *view;
    /* the fichier object will open archives and find which compresor to use*/
    CArchiveChoice *archivechoice;
    /* This in an important variable that handles what karchiveur is doing (compressing, extracting...) */
    int operation;
    /* The processus object, it will run the compressors...*/
    CProcessus *process;
    /* The location of karchiveur's temporary directory*/
    QString tmpdir;
    /* The location of karchiveur's temporary directory for undo operations*/
    QString tmpdirundo;
    /* Contains the default directory for opening*/
    int optionOpening;
    /*Overwrite files when extracting*/
    bool overwrite;
    /*A counter for the progress bar*/
    int counter;
    /* The file used to uncompress gzip and bzip2 archives*/
    FILE* fichierIO;
    /* The progrezss bar*/
    QProgressBar /*KProgress*/ *progress;
    /* The led indicating whenever the application is busy */
    CLed* led;
    /* When adding files or creating anarchive, also add subfolders */
    bool recursive;
    /* The archive browser object */
    CArchiveBrowser* navigateur;
    /* The search tool object*/
    CSearch* searchBox;
    /* When dropping a file, add all the path (i.e. /home/user/dropfiles) if true*/
    bool includewholepath;
    /* if true, add / at top of paths */
    bool cheminabsolu;
    /* The compress rate for gzip and bzip2*/
    int compresslevel;
    /* A buffer used to store the stdout when reading an archive*/
    char m_buffer[1024];
    /* If true, read the archive using streams. It is fast, but at this time, it freezes
     * the GUI. If false, store in m_buffer the stdout using signal/slot mechanism*/
    bool readarchivewithstream;
    /* An index used to store the current item while searching*/
    int indexfind;
    /* the Find in this archive tool*/
    CFind* find;
    /*The tip of the day object*/
    KTipofDay* tipofday;
    /*Contains the list of last removed files, for undo operations*/
    QStringList listUndo;
    /*Contains the list of last removed files, for redo operations*/
    QStringList listRedo;
    /* true if we'll display the tipofday at startup */
    bool displaytipofday;
    /* View mode: directory by directory, or all files at once */
    bool viewbydirectories;
    /* Prefered archive type; stores its extension */
    QString preferedArchiveType;
    /*if true, don't show a dialog when dropping some files, instead set a default behaviour*/
    bool defaultdropbehaviour;
    bool m_promptdir;
    bool m_chooseExtractDirFromArchive;
    QString m_chemin;
    QString m_extr;
    bool controlkeypressed;
    CArchiveOperation* archiveoperation;
    CArchive* archiveobj;
    struct statusBarMessage {
      int nbselectedfiles;
      int sizeselectedfiles;
    } selectedfilesStatusbarMessage;
    
    /* The actions to create the GUI*/
    KAction *fileNewWindow;
    KAction *fileNewArchive;
    KAction *fileOpenArchive;
    KAction *fileCryptArchive;
    KAction *fileMailArchive;
    KAction *fileSearchArchive;
    KRecentFilesAction *fileOpenRecent;
    KAction *fileConvertArchive;
    KAction *fileMakeSfxArchive;
    KAction *fileInfosArchive;
    KAction *filePrint;
    KAction *fileCloseArchive;
    KAction *fileQuit;
    CAnimatedAction *archiveExtract;
    KAction *archiveTest;
    KAction *archiveScan;
    KAction *archiveAdd;
    KAction *archiveView;
    KAction *archiveViewSelection;
    KAction *archiveSetPassword;
    KAction *archiveDeleteSelection;
    KAction *archiveDeleteToTrashSelection;
    KAction *archiveProprieties;
    KAction *archiveWizard;
    KAction *editUndo;
    KAction *editRedo;
    KAction *editCut;
    KAction *editCopy;
    KAction *editPaste;
    KAction *editSelectAll;
    KAction *editUnselectAll;
    KAction *editFind;
    KAction *diskSplit;
    KToggleAction *viewToolbar;
    KToggleAction *viewStatusbar;
    KToggleAction *viewArchiveBrowser;
    KAction *viewPreferences;
    KAction *viewUpdate;
    /**Combo that displays archive's directories*/
    KComboBox *cbdirectories;
    CAnimation* animation;
};
 
#endif // KARCHIVEUR_H
