/***************************************************************************
                          processus.h  -  description
                             -------------------
    begin                : Sat Jun 5 1999
    copyright            : a little improvement of kprocess.h (C) Christian Czezatke by Eric Coquelle
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __PROCESSUS_H__
#define __PROCESSUS_H__

#include <stdio.h>

#include <kprocess.h>
#include <qstringlist.h>

class CProcessus : public KProcess {
Q_OBJECT
public:
  
  CProcessus();
  CProcessus(QObject * parent , const char* name = 0L);
  
  /**Let's use streams to speed up the software*/
  bool start(FILE** flot, Communication comm=NoCommunication, RunMode runmode=DontCare);
  bool start(RunMode runmode=NotifyOnExit, Communication comm=NoCommunication);
  KProcess& operator<< (const QStringList &args);
  KProcess& operator<< (const QString &arg);
  KProcess& operator<< (const QCString &arg);
  KProcess& operator<< (const char* arg);
  void clearArguments();
  void prepareSubProcess();
  virtual bool kill (int signo=SIGTERM);
  
private slots:
  void endSplitProcess(KProcess *proc);
  void stdoutSplitProcess(KProcess* , char* , int );
  void stderrSplitProcess(KProcess* , char* , int );

private:
  bool splitprocess;
  static const unsigned int maxnumberofarguments;
  QStringList argumentslist;
  unsigned int positionargumentslist;
  unsigned int maxargumentslist;
  KProcess my_splitprocess;
  QStringList parameters;
  RunMode m_runmode;
  Communication m_communication;
  unsigned int positionlistfilesinparameters;
};

#endif



