import datetime
import calendar
import locale
locale.setlocale(locale.LC_ALL,'')

print '<html><head>'
print '<title>Blog</title>'
print '<link rel="stylesheet" type="text/css" href="../blog.css">'
print '</head><body>'
print '<a href="../../..">'
print '<img src="/doc/images/karrigell_skeudenn.png" border="0" width="100">'
print '</a>'
print '<form action = "new_entry"><input type="submit" value="New">'
print '</form>'
print '<p>'
print '<div class="header">'
print '<div class="blogtitle">Karrigell Blog Demo</div></div>'

from buzhug import Base
try:
    db = Base('blog').open()
except IOError:
    db = Base('blog').create(('parent',int),('title',str),
        ('author',str),('text',str),('date',datetime.datetime))
    
def index(year=None,month=None):
    """Print all the threads for specified month"""
    if year is None:
        today = datetime.date.today()
        year,month = today.year,today.month
    else:
        year,month = int(year),int(month)
    # get all threads
    threads = db.select(parent=-1)
    months = set([(t.date.year,t.date.month) for t in threads ])
    # only threads for current month
    threads = [ t for t in threads if t.date.year == year
        and t.date.month == month ]
    # sort by date
    threads.sort(lambda t1,t2:cmp(t2.date,t1.date))
    days = set([t.date.day for t in threads ])

    # print current month calendar
    print '<table cellspacing="10">'
    print '<tr><td valign="top">'
    print datetime.date(year,month,1).strftime('%B %Y')+'<br>'
    print '<pre>'
    print calendar.weekheader(3)
    for week in calendar.monthcalendar(year,month):
        ws = ''
        for day in week:
            if day == 0:
                ws += '    '
            elif day in days:
                ws += '<a class="days" href="#msg%s">%3s</a> ' %(day,day)
            else:
                ws += '%3s '%day
        print ws
    print '</pre>'
    
    print '<p>Archives'
    arch = list(months)
    arch.sort()
    for line in arch:
        d = datetime.date(line[0],line[1],1)
        print '<br><a class="archive" href="index?year=%s&month=%s">%s</a>' %(d.year,
            d.month,d.strftime('%B %Y'))
    print '</td>'
    
    # print threads for current month
    print '<td valign="top">'
    for r in threads:
        comments = db.select(parent=r.__id__)
        print '<a name="msg%s">' %r.date.day
        print '<div class="day">%s</div>' %r.date.strftime('%x')
        print '<div class="title">%s</div>' %r.title
        print '<p><div class="text">',r.text,'</div>'
        print '<p><div class="posted">Posted by %s at %s</div>' \
            %(r.author,r.date.strftime('%H:%M:%S'))
        print '<p><div class="posted">'
        print '<a class="comments" href="showComments?parent=%s">' \
            '%s comments</a></div><p>' %(r.__id__,len(comments))
    print '</td></tr></table>'
    print '</body></html>'

def showComments(parent):
    parent = int(parent)
    r_parent = db[parent]
    p_date = r_parent.date
    comments = db.select(parent=parent)
    for comment in comments:
        print '<div class="title">'+comment.title+'</div>'
        print '<p><div class="text">'+comment.text+'</div>'
        print '<p><div class="posted">Posted by %s %s</div><p>' %(comment.author,
            comment.date.strftime('%x at %H:%M:%S'))
    print '<hr>'
    new_entry(title=r_parent.title,parent=parent)
    print '<a href="index?year=%s&month=%s">' %(p_date.year,p_date.month)
    print 'Cancel</a>'

def new_entry(title='',parent=-1):
    print '<form action="insert_entry" method="post">'
    print '<input type="hidden" name="parent" value="%s">' %parent
    print '<table>'
    print '<tr><td>Name</td><td><input name="author"></tr>'
    print '<tr><td>Title</td><td><input name="title" size="50" value="%s"></tr>' %title
    print '<tr><td>Text</td>'
    print '<td><textarea name="text" rows="20" cols="50"></textarea></td></tr>'
    print '</table>'
    print '<input type="submit" value="Ok"></form>'

def insert_entry(**kw):
    kw['parent'] = int(kw['parent'])
    if kw['parent'] == -1:
        t_date = datetime.date.today()
    else:
        t_date = db[kw['parent']].date
    kw['date'] = datetime.datetime.now()
    db.insert(**kw)
    db.commit()
    raise HTTP_REDIRECTION,"index?year=%s&month=%s" %(t_date.year,t_date.month)
