import os
import kirbybase

db=kirbybase.KirbyBase()
table="records.tbl"
try:
    db.create(table,["title:str","artist:str"])
except:
    pass

def index():
    records=db.select(table,["recno"],["*"],returnType='object')
    if records:
        Include("../recordsHeader.pih",title="My record collection")
        print '<h1>My record collection</h1>'
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr><th>Title</th><th>Artist</th>'
        print '<th>&nbsp;</th><th>&nbsp;</th></tr>\n'
        for record in records:
            print '<tr>'
            print '<td class="main">%s</td><td class="main">%s</td>' %(record.title,record.artist)
            print '<td class="main"><a href="removeRecord?recordId=%s">' %record.recno
            print 'Remove</a></td>'
            print '<td class="main"><a href="editRecord?recordId=%s">' %record.recno
            print 'Edit</a></td>'
            print '</tr>'
        print '</table>'
    else:
        print "No record in this collection"

    print '<p><a href="editRecord?recordId=-1">New record</a>'
    print '</body>\n</html>'

def editRecord(recordId):
    recordId=int(recordId)
    if recordId>-1:
        record=db.select(table,["recno"],[recordId],returnType='object')[0]
        title,artist=record.title,record.artist
        Include("../recordsHeader.pih",title="Editing record %s" %recordId)
        print "<h1>Editing a record</h1>"
    else:
        title,artist='',''
        Include("../recordsHeader.pih",title="New record")
        print "<h1>New record</h1>"
    
    print '<form action="insertRecord">'

    print '<input type="hidden" name="recordId" value="%s">' %recordId
    print '<table>'
    print '<tr><td>Title</td><td><input name="title" size="40" value="%s"></td></tr>' %title
    print '<tr><td>Artist</td><td><input name="artist" size="40" value="%s"></td></tr>' %artist
    print '</table>'
    print '<input type="submit" value="Ok">'
    print '</form>'
    print '</body>\n</html>'

def insertRecord(recordId,title,artist):
    recordId=int(recordId)
    if recordId==-1:
        db.insert(table,[title,artist])
    else:
        db.update(table,["recno"],[recordId],[title,artist])
    db.pack(table)
    raise HTTP_REDIRECTION,"index"

def removeRecord(recordId):
    db.delete(table,["recno"],[int(recordId)])
    db.pack(table)
    raise HTTP_REDIRECTION,"index"
