/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kdebug.h>

#include "katindexermanager.h"
#include "katdaemonlist.h"
#include "katdaemon.h"
#include <kat_export.h>

extern "C" {
   KAT_EXPORT KDEDModule* create_katd( const QCString& name ) {
       return new KatDaemon( name );
   }
}

KatDaemon::KatDaemon( const QCString& name )
    : KDEDModule( name )
{
    m_iManager = KatIndexerManager::indexerManager();
    m_daemonStatus = new DlgDaemonStatus( m_iManager, 0, "KDEDKatDaemonStatus" );
}

KatDaemon::~KatDaemon()
{
    m_iManager->stopIndexer();
    delete m_iManager;
    m_iManager = 0;
    delete m_daemonStatus;
    m_daemonStatus = 0;
}

void KatDaemon::reInitialize()
{
    m_iManager->reInitialize();
}

void KatDaemon::updateCatalogs()
{
    m_iManager->updateCatalogs();
}

bool KatDaemon::addCatalog( int catalogId )
{
    return m_iManager->addCatalog( catalogId );
}

bool KatDaemon::deleteCatalog( int catalogId )
{
    return m_iManager->deleteCatalog( catalogId );
}

bool KatDaemon::updateCatalog( int catalogId )
{
    return m_iManager->updateCatalog( catalogId );
}

void KatDaemon::changeIdleLoadMaxWait( int load,  int _wait, QStringList lstFolder, QStringList lstFile )
{
    setIdleLoad(load );
    setMaxWait( _wait );
    setExcludeFolderList( lstFolder);
    setExcludeFilesList( lstFile );
    m_iManager->updateCatalogs();
}

void KatDaemon::setIdleLoad( int load )
{
    m_iManager->setSchedulerLoad( load );
}

int KatDaemon::idleLoad() const
{
    return m_iManager->schedulerLoad();
}


void KatDaemon::setMaxWait( int _wait )
{
    m_iManager->setMaxWait( _wait );
}

int KatDaemon::maxWait() const
{
    return m_iManager->maxWait();
}


QStringList KatDaemon::listOfCatalog()
{
    return m_iManager->listOfCatalog();
}


QStringList KatDaemon::excludeFolderList()
{
    return m_iManager->excludeFolderList();
}

QStringList KatDaemon::excludeFilesList()
{
    return m_iManager->excludeFilesList();
}

void KatDaemon::setExcludeFolderList( QStringList lst)
{
    m_iManager->setExcludeFolderList( lst );
}

void KatDaemon::setExcludeFilesList( QStringList lst)
{
    m_iManager->setExcludeFilesList( lst );
}


#include "katdaemon.moc"
