/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <qlabel.h>
#include <qvbox.h>
#include <qimage.h>
#include <kaction.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <kaboutdata.h>
#include <kaboutapplication.h>
#include <katcatalog.h>
#include <kapplication.h>
#include <katutils.h>
#include <kaboutdata.h>
#include <knotifydialog.h>
#include <kdeversion.h>

#include "catalogstatusitem.h"
#include "katdaemonlist.h"
#include "katindexermanager.h"
#include "kattray.h"

DlgDaemonStatus::DlgDaemonStatus( KatIndexerManager* manager, QWidget* parent, const char* name, bool modal, WFlags )
    : KDialogBase( parent, name, modal, "", KDialogBase::Close, KDialogBase::Close, true ),  tray( 0L )
{
    KGlobal::locale()->insertCatalogue("kat");
    m_iManager = manager;

    connect( m_iManager, SIGNAL( initialized() ), this, SLOT( managerStarted() ) );
    connect( m_iManager, SIGNAL( statusChanged( int, int, QString ) ),
             this, SLOT( updateStatus( int, int, QString ) ) );
    connect( m_iManager, SIGNAL( subStatusChanged( int, int, QString ) ),
             this, SLOT( updateSubStatus( int, int, QString ) ) );
    connect( m_iManager, SIGNAL( progressChanged( int, int ) ),
             this, SLOT( updateProgress( int, int ) ) );
    connect( m_iManager, SIGNAL( currentFileChanged( int, QString ) ),
             this, SLOT( updateCurrentFile( int, QString ) ) );

    connect( m_iManager, SIGNAL( catalogAdded( int ) ),
             this, SLOT( slotAddCatalog( int ) ) );
    connect( m_iManager, SIGNAL( catalogDeleted( int ) ),
             this, SLOT( slotDeleteCatalog( int ) ) );

    m_box = new QVBox( this );

    m_catalogCombo = new KComboBox( false, m_box, "CatalogCombo" );
    m_statusItem = new CatalogStatusItem( m_box, "CatalogStatus" );

    connect ( m_catalogCombo, SIGNAL ( activated ( int ) ), this, SLOT ( changeCatalog ( int ) ) );
    connect ( m_statusItem, SIGNAL( stop() ), this, SLOT( stopIndexer() ) );
    connect ( m_statusItem, SIGNAL( start() ), this, SLOT( startIndexer() ) );
    connect ( m_statusItem, SIGNAL( pause() ), this, SLOT( pauseIndexer() ) );
    connect ( m_statusItem, SIGNAL( ajustDialogSize() ), this, SLOT( slotUpdateSize() ) );

    m_currentCatalogId = 0;

    m_box->setSpacing( 5 );

    // Setup Tray
    tray = new KatTray( this, "KatTray" );
    m_iManager->setWinId( tray->winId() );
    // Create Actions
    // Start, stop, pause actions
    KAction* startAllAction = new KAction( i18n( "&Start All" ),
                                           "player_play",
                                           0,
                                           this,
                                           SLOT( slotStartAll() ),
                                           tray->actionCollection(),
                                           "start_all"
                                         );
    KAction* stopAllAction  = new KAction( i18n( "S&top All" ),
                                           "player_stop",
                                           0,
                                           this,
                                           SLOT( slotStopAll() ),
                                           tray->actionCollection(),
                                           "stop_all"
                                         );

    KAction* pauseAllAction  = new KAction( i18n( "&Pause All" ),
                                            "player_pause",
                                            0,
                                            this,
                                            SLOT( slotPauseAll() ),
                                            tray->actionCollection(),
                                            "pause_all"
                                          );

    /* configure, about dialog, show hide actions */
    KAction* configureAction  = new KAction( i18n( "&Configure KAT" ),
                                             "configure",
                                             0,
                                             this,
                                             SLOT( slotConfigure() ),
                                             tray->actionCollection(),
                                             "configure_kat"
                                           );

    KAction* configureNotify  =KStdAction::configureNotifications(this, SLOT(slotConfigureNotifications()), tray->actionCollection());

    KAction* aboutAction  = new KAction( i18n( "&About KAT" ),
                                         "kat",
                                         0,
                                         this,
                                         SLOT( slotShowAbout() ),
                                         tray->actionCollection(),
                                         "about_dialog"
                                       );

    KPopupMenu* trayMenu = tray->contextMenu();

    startAllAction->plug( trayMenu );
    pauseAllAction->plug( trayMenu );
    stopAllAction->plug( trayMenu );

    trayMenu->insertSeparator();

    configureAction->plug( trayMenu );

    configureNotify->plug( trayMenu );

    trayMenu->insertSeparator();

    aboutAction->plug( trayMenu );

    tray->show();

    /* FIXME - Enable below if running from KDED Module instead of standalone client
     * to disable showing of Quit button  */

    if ( QString( name ) != "KatDaemonStatus" )
    {

        KAction* quitAction = tray->actionCollection()->action( "file_quit" );
        if ( quitAction )
        {
            quitAction->unplug( trayMenu );
            tray->actionCollection()->remove( quitAction );
        }
    }

    managerStarted();

    setMainWidget ( m_box );
}


void DlgDaemonStatus::slotUpdateSize()
{
    adjustSize();
}


void DlgDaemonStatus::slotConfigureNotifications()
{
  	KAboutData notifyAbout = katAboutData();
   KNotifyDialog::configure(this, "Notification Configuration Dialog", &notifyAbout);
}

void DlgDaemonStatus::slotAddCatalog( int catalogId )
{
    KatCatalog* cat = m_iManager->catalog( catalogId );

    m_catalogCombo->insertItem( cat->name() );
    //m_catalogCombo->insertItem( cat->path() );
    m_catalogIds.append( cat->catalogId() );

    if ( m_catalogIds.count() == 1 )
        changeCatalog( 0 );
}

void DlgDaemonStatus::slotDeleteCatalog( int catalogId )
{
    m_catalogCombo->removeItem( m_catalogIds.findIndex( catalogId ) );
    m_catalogIds.remove( catalogId );

    if ( m_catalogIds.count() > 0 )
        changeCatalog( 0 );
}

void DlgDaemonStatus::changeCatalog( int comboId )
{
    if ( comboId >= ( int )m_catalogIds.count() )
    {
        kdDebug() << "No catalog exists for the combo box entry index " << comboId << endl;
        return;
    }
    int catalogId = m_catalogIds[ comboId ];

    KatCatalog* cat = m_iManager->catalog( catalogId );
    if ( !cat )
    {
        kdDebug() << "No indexer for catalog with id " << catalogId << endl;
        return;
    }

    QString statusString;
    QString subStatusString;
    QString currentFile;
    int progress;
    int status;
    int subStatus;

    if( m_iManager->catalogStatus( catalogId, status, statusString, subStatus, subStatusString, progress, currentFile ) )
    {
        m_statusItem->setCatalog ( cat, status, statusString, subStatus, subStatusString, progress, currentFile );
        m_currentCatalogId = catalogId;
    }
    else
    {
        kdDebug() << "No indexer for catalog with id " << catalogId << endl;
        return;
    }
    m_catalogCombo->setCurrentItem( comboId );
}

void DlgDaemonStatus::slotStartAll()
{
    m_iManager->startIndexer();
}

void DlgDaemonStatus::slotStopAll()
{
    m_iManager->stopIndexer();
}

void DlgDaemonStatus::slotPauseAll()
{
    m_iManager->pauseIndexer();
}

void DlgDaemonStatus::slotConfigure()
{
    QStringList args;
    args << "katcontrol";
    KApplication::kdeinitExec( "kcmshell", args );
}

void DlgDaemonStatus::slotShowAbout()
{
    KAboutData about( katAboutData() );
#if KDE_IS_VERSION(3,3,90)
    about.setProgramLogo( QImage( KGlobal::iconLoader()->iconPath( "kat", KIcon::Panel ) ) );
#endif
    KAboutApplication aboutApp( &about );

    aboutApp.exec();
}

void DlgDaemonStatus::stopIndexer()
{
    if ( m_currentCatalogId )
        m_iManager->stopIndexer( m_currentCatalogId );
}

void DlgDaemonStatus::startIndexer()
{
    if ( m_currentCatalogId )
        m_iManager->startIndexer( m_currentCatalogId );
}

void DlgDaemonStatus::pauseIndexer()
{
    if ( m_currentCatalogId )
        m_iManager->pauseIndexer( m_currentCatalogId );
}

void DlgDaemonStatus::managerStarted()
{
    QPtrList<KatCatalog> catalogs = m_iManager->catalogs();

    m_catalogIds.clear();
    m_catalogCombo->clear();

    for ( KatCatalog* cat = catalogs.first(); cat; cat = catalogs.next() )
    {
        m_catalogCombo->insertItem( cat->name() );
        //m_catalogCombo->insertItem( cat->path() );
        m_catalogIds.append( cat->catalogId() );
    }

    if ( m_catalogIds.count() > 0 )
        changeCatalog( 0 );
}

void DlgDaemonStatus::updateCurrentFile( int catalogId, QString file )
{
    if ( catalogId  == m_currentCatalogId )
        m_statusItem->slotUpdateCurrentFile( file );
}

void DlgDaemonStatus::updateProgress( int catalogId, int progress )
{
    if ( catalogId  == m_currentCatalogId )
        m_statusItem->slotUpdateProgress( progress );
}

void DlgDaemonStatus::updateStatus( int catalogId, int status, QString statusString )
{
    if ( catalogId  == m_currentCatalogId )
        m_statusItem->slotUpdateStatus( status, statusString );
}

void DlgDaemonStatus::updateSubStatus( int catalogId, int status, QString statusString )
{
    if ( catalogId  == m_currentCatalogId )
        m_statusItem->slotUpdateSubStatus( status, statusString );
}

void DlgDaemonStatus::slotClose()
{
    hide();
}

#include "katdaemonlist.moc"
