/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include <kdialogbase.h>
#include <qtimer.h>
#include <katutils.h>
#include "katdaemonlist.h"
#include "katindexermanager.cpp"

int main( int argc, char** argv )
{
    KAboutData about( katAboutData() );

    KCmdLineArgs::init( argc, argv, &about );

    KApplication app;

    KatIndexerManager* manager = KatIndexerManager::indexerManager();

    DlgDaemonStatus *daemonDlg = new DlgDaemonStatus( manager, 0, "KatDaemonStatus" );

    app.setMainWidget( daemonDlg );
    daemonDlg->show();

    int returnVal = app.exec();

    delete manager;
    manager = 0;

    return returnVal;
}
