/*
 * dict.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __DICT_HH__
#define __DICT_HH__

#include <string>
#include <vector>
#include "conf.hh"
#include "dispatcher.hh"
#include "DICTClient.hh"

// TODO: Auth not implemented
// TODO: strategies not implemented.
// TODO: Implement timeout.
// TODO: Make the errors in DICTClient translatable.

typedef DICTClient::Definitions Definitions;
typedef DICTClient::DBs Books;
typedef DICTClient::DB Book;

class Dict {
public:
  Dict(std::string&, int, int);
  ~Dict();
  bool define(std::string&, std::string&, Definitions&, std::string&);
  bool get_books(Books&, std::string&);
  bool ok(std::string&);
private:
  DICTClient dc;
};

// TODO: Multiple servers support.
void katoob_dict_define_word(Conf&, Dispatcher *);
bool katoob_dict_get_books(Conf&, Books&, std::string&);

#endif /* __DICT_HH__ */
