/*
 * label.cc
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <gtkmm/stock.h>
#include "label.hh"
#include "utils.hh"
#include "macros.h"

Label::Label(Conf& conf) :
  _conf(conf),
  _readonly(false),
  _modified(false)
{
  std::string path = Utils::get_data_path("close.png");

  Gtk::Image *image = Gtk::manage(new Gtk::Image(path));

  close.set_image(*image);
  close.set_relief(Gtk::RELIEF_NONE);
  close.set_size_request(16, 16);
  close.set_border_width(0);

  close.signal_clicked().connect(sigc::mem_fun(this, &Label::close_clicked_cb));

  //  label.set_use_markup();

  pack_start(label);
  pack_start(close);
  label.show();
  if (_conf.get("showclose", true))
    close.show();
  normal();
}

Label::~Label()
{
}

void Label::set(int num)
{
  label.set_text(Utils::substitute(_("Untitled New %d"), num));
  //  normal();
}

void Label::set(std::string& str)
{
  label.set_text(str);
  // normal();
}

void Label::reset_gui()
{
  if (_conf.get("showclose", true))
    close.show();
  else
    close.hide();
}

void Label::readonly(bool ro, bool force)
{
  // A modified document can't be read only.
  if (_modified)
    return;

  if (!force)
    if (ro == _readonly)
      return;

  if (ro)
    katoob_set_color(_conf, label, Utils::KATOOB_COLOR_READONLY);
  else
    normal();
  _readonly = ro;
}

void Label::modified(bool m, bool force)
{
  // A read only document can't be modified.
  if (_readonly)
    return;

  if (!force)
    if (m == _modified)
      return;

  if (m)
    katoob_set_color(_conf, label, Utils::KATOOB_COLOR_MODIFIED);
  else
    normal();
  _modified = m;
}

void Label::normal()
{
  katoob_set_color(_conf, label, Utils::KATOOB_COLOR_NORMAL);
}
