/*
 * print.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PRINT_HH__
#define __PRINT_HH__

#include "conf.hh"
#include "cups.hh"
#include "ps.hh"
#include "pdf.hh"

class Print : public Cups, public PS, public PDF {
public:
  Print(Conf&);
  ~Print();
  void set_type(int t) { _type = t; }
  void set_file(std::string& f) { _file = f; }
  void set_copies(int c) { _copies = c; }
  void start_process();
  bool end_process(std::string&);
  bool ok(std::string& e);

  /*
  bool write(std::string&, std::string&);
  bool write_pdf(std::string&, std::string&);
  bool print();
  */
private:
  int _type; // 1 = PS, 0 = PDF, -1 = print.
  std::string _file;
  int _copies;
};

#endif /* __PRINT_HH__ */
