/*
 * toolbar.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __TOOLBAR_HH__
#define __TOOLBAR_HH__

#include <gtkmm/toolbar.h>
#include <gtkmm/separatortoolitem.h>
#include <gtkmm/label.h>
#include <gtkmm/entry.h>
#include <gtkmm/box.h>
#include <gtkmm/separator.h>
#include <gtkmm/comboboxtext.h>
#include "conf.hh"

class Toolbar {
public:
  Toolbar(Conf&);
  ~Toolbar();
  Gtk::Toolbar& main() { return _main; };
  Gtk::VBox& extended() { return _extended; };

  Gtk::ToolButton& create() { return _create; }
  Gtk::ToolButton& open() { return _open; }
  Gtk::ToolButton& save() { return _save; }
#ifdef ENABLE_PRINT
  Gtk::ToolButton& print() { return _print; }
#endif
  Gtk::ToolButton& close() { return _close; }
  Gtk::ToolButton& undo() { return _undo; }
  Gtk::ToolButton& redo() { return _redo; }
  Gtk::ToolButton& cut() { return _cut; }
  Gtk::ToolButton& copy() { return _copy; }
  Gtk::ToolButton& paste() { return _paste; }
  Gtk::ToolButton& erase() { return _erase; }
  Gtk::Entry& go_to() { return _go_to; }
#ifdef HAVE_SPELL
  Gtk::Entry& search() { return _search; }
  Gtk::Widget& dictionary() { return _dictionary; }
#endif
  sigc::signal<void, std::string> search_activated;
  sigc::signal<void, int> goto_activated;
  sigc::signal<void, std::string> signal_extra_button_clicked;
  Gtk::Widget& extra_buttons() { return _extra_buttons; }

  /* Signal callbacks. */
  void text();
  void icons();
  void both();
  void beside();

#ifdef HAVE_SPELL
  Gtk::Button& spell() { return _spell; }
  void set_dictionary(std::string&);
  std::string get_dictionary();
  sigc::signal<void, std::string> dictionary_changed;
#endif

  void reset_gui();

private:
  void search_activate_cb();
  void go_to_activate_cb();

  void create_extra_buttons();
  bool create_extra_button(std::string&);
  void extra_button_clicked(std::string str) { signal_extra_button_clicked.emit(str); }
  Gtk::Toolbar _extra_buttons;

#ifdef HAVE_SPELL
  void _dictionary_changed();
  sigc::connection dictionary_changed_conn;
#endif

  Conf& _conf;

  Gtk::Toolbar _main;
  Gtk::VBox _extended;

  Gtk::SeparatorToolItem s1, s2, s3;

  Gtk::ToolButton _create;
  Gtk::ToolButton _open;
  Gtk::ToolButton _save;
#ifdef ENABLE_PRINT
  Gtk::ToolButton _print;
#endif
  Gtk::ToolButton _close;
  Gtk::ToolButton _undo;
  Gtk::ToolButton _redo;
  Gtk::ToolButton _cut;
  Gtk::ToolButton _copy;
  Gtk::ToolButton _paste;
  Gtk::ToolButton _erase;

  /* Extended */
  Gtk::HBox box;
  Gtk::HSeparator sep;
  Gtk::Label _go_to_l, _search_l;
#ifdef HAVE_SPELL
  Gtk::Label _dictionary_l;
  Gtk::Button _spell;
  Gtk::ComboBoxText _dictionary;
#endif
  Gtk::Entry _go_to, _search;
  //  Gtk::HBox hbox;
};

#endif /* __TOOLBAR_HH__ */
