#include <zlib.h>
#include <stdio.h>
#include <KayaAPI.h>

#include "zlib_glue.h"

void* compressBuffer(void* in, int len, KayaValue buflen)
{
    uLong outlen = compressBound(len);
    uLong inlen = len;
    Byte* out = (Byte*)KayaAlloc(outlen);
    int err = compress(out, &outlen, (Byte*)in, inlen);

    //    printf("compressed %d to %d (%d)\n",len, outlen, err);

    KayaSetInt(buflen,outlen);
    return (void*)out;
}

void* uncompressBuffer(void* in, int len, KayaValue outlen)
{
    uLong blen = KayaGetInt(outlen);
    Byte* out = (Byte*)KayaAlloc(blen);
    int err = uncompress(out, &blen, (Byte*)in, len);

    //    printf("uncompressed %d to %d (%d)\n",len,blen, err);

    KayaSetInt(outlen,blen);
    return (void*)out;    
}

