/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_PROMPT_DIALOG_H__
#define __KZ_PROMPT_DIALOG_H__

#include <gtk/gtk.h>

#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_PROMPT_DIALOG		 (kz_prompt_dialog_get_type ())
#define KZ_PROMPT_DIALOG(obj)		 (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PROMPT_DIALOG, KzPromptDialog))
#define KZ_PROMPT_DIALOG_CLASS(klass)	 (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_PROMPT_DIALOG, KzPromptDialogClass))
#define KZ_IS_PROMPT_DIALOG(obj)	 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PROMPT_DIALOG))
#define KZ_IS_PROMPT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_PROMPT_DIALOG))
#define KZ_PROMPT_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_PROMPT_DIALOG, KzPromptDialogClass))

typedef struct _KzPromptDialog           KzPromptDialog;
typedef struct _KzPromptDialogClass      KzPromptDialogClass;

typedef enum {
	TYPE_ALERT,
        TYPE_ALERT_CHECK,
        TYPE_CONFIRM,
        TYPE_CONFIRM_CHECK,
        TYPE_PROMPT,
        TYPE_PROMPT_USER_PASS,
        TYPE_PROMPT_PASS,
        TYPE_SELECT,
        TYPE_UNIVERSAL
} PromptType ;

struct _KzPromptDialog
{
	GtkDialog parent;
};

struct _KzPromptDialogClass
{
	GtkDialogClass parent_class;
};

GType        kz_prompt_dialog_get_type   (void) G_GNUC_CONST;
GtkWidget   *kz_prompt_dialog_new               (PromptType type);
GtkWidget   *kz_prompt_dialog_new_with_parent   (PromptType type, GtkWindow *parent_window);

void         kz_prompt_dialog_set_host          (KzPromptDialog *prompt, const gchar *hostname);
void         kz_prompt_dialog_set_title         (KzPromptDialog *prompt, const gchar *title);
void         kz_prompt_dialog_set_text_value    (KzPromptDialog *prompt, const gchar *text);
void         kz_prompt_dialog_set_check_message (KzPromptDialog *prompt, const gchar *check_message);
void         kz_prompt_dialog_set_check_value   (KzPromptDialog *prompt, const gboolean value);
void         kz_prompt_dialog_set_message_text  (KzPromptDialog *prompt, const gchar *message_text);
void         kz_prompt_dialog_set_user          (KzPromptDialog *prompt, const gchar *user);
void         kz_prompt_dialog_set_password      (KzPromptDialog *prompt, const gchar *pass);
void         kz_prompt_dialog_set_buttons       (KzPromptDialog *prompt, const gchar *button0_label,
                      			         const gchar *button1_label,
	              	                         const gchar *button2_label);
void         kz_prompt_dialog_set_items         (KzPromptDialog *prompt, const gchar **item_array, guint count);

gboolean     kz_prompt_dialog_get_check_value   (KzPromptDialog *prompt);
gboolean     kz_prompt_dialog_get_confirm_value (KzPromptDialog *prompt);
const gchar *kz_prompt_dialog_get_text_value    (KzPromptDialog *prompt);
const gchar *kz_prompt_dialog_get_user          (KzPromptDialog *prompt);
const gchar *kz_prompt_dialog_get_password      (KzPromptDialog *prompt);
gint         kz_prompt_dialog_get_button_pressed(KzPromptDialog *prompt);
gint         kz_prompt_dialog_get_selected_item (KzPromptDialog *prompt);

void         kz_prompt_dialog_run               (KzPromptDialog *prompt);

G_END_DECLS

#endif /* __KZ_PROMPT_DIALOG_H__ */
