/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

void KbfxConfigDlgFonts::init()
{
}

void KbfxConfigDlgFonts::ChangeForm()
{
  KbfxThemeList->clear();

  KbfxThemeList->insertStringList(KbfxThemesData().setThemeList(ConfigInit().m_UserSpinxThemeBasePath).keys());

  ConfigInit().readFontrc(ConfigInit().m_SpinxThemeBasePath,
                          ConfigInit().m_SpinxThemeName);

  KbfxThemeList->setCurrentItem(ConfigInit().m_SpinxThemeName);
  KbfxFontSize->setCurrentItem(QString::number(ConfigInit().m_fontSize));
  KbfxApplicationColor->setColor(ConfigInit().m_fontAppNameColor);
  KbfxCommentColor->setColor(ConfigInit().m_fontAppCommentColor);
  KbfxLineColor->setColor(ConfigInit().m_lineColor);
  KbfxCategoryColor->setColor(ConfigInit().m_fontIndexColor);
  KbfxNameColor->setColor(ConfigInit().m_userNameColor);
  KbfxSeparatorColor->setColor(ConfigInit().m_sepNameColor);
}

void KbfxConfigDlgFonts::ChangeFormDefaults()
{
  KbfxThemeList->clear();

  KbfxThemeList->insertStringList(KbfxThemesData().setThemeList(ConfigInit().m_UserSpinxThemeBasePath).keys());

  KbfxThemeList->setCurrentItem(ConfigInit().m_SpinxThemeName);
  KbfxFontSize->setCurrentItem(QString::number(ConfigInit().m_fontSize));
  KbfxApplicationColor->setColor(ConfigInit().m_fontAppNameColor);
  KbfxCommentColor->setColor(ConfigInit().m_fontAppCommentColor);
  KbfxLineColor->setColor(ConfigInit().m_lineColor);
  KbfxCategoryColor->setColor(ConfigInit().m_fontIndexColor);
  KbfxNameColor->setColor(ConfigInit().m_userNameColor);
  KbfxSeparatorColor->setColor(ConfigInit().m_sepNameColor);
}

void KbfxConfigDlgFonts::KbfxFontsThemeSelected(const QString &theme)
{
  ConfigInit().m_SpinxThemeName = theme;
  ConfigInit().m_SpinxThemeBasePath = KbfxThemesData().setThemeList(ConfigInit().m_UserSpinxThemeBasePath)[theme];
  ChangeForm();
}

void KbfxConfigDlgFonts::KbfxFontSizeSelected(const QString &size)
{
  ConfigInit().m_KbfxGlobalChange = TRUE;
  ConfigInit().m_fontSize = size.toUInt();

  kdDebug() << "Font size: " << ConfigInit().m_fontSize << endl;
}

void KbfxConfigDlgFonts::KbfxApplicationColorSelected(const QColor &color)
{
  ConfigInit().m_KbfxGlobalChange = TRUE;
  ConfigInit().m_fontAppNameColor = color;

  kdDebug() << "Application color: "
            << ConfigInit().m_fontAppNameColor
            << endl;
}

void KbfxConfigDlgFonts::KbfxCommentColorSelected(const QColor &color)
{
  ConfigInit().m_KbfxGlobalChange = TRUE;
  ConfigInit().m_fontAppCommentColor = color;

  kdDebug() << "Comment color: "
            << ConfigInit().m_fontAppCommentColor
            << endl;
}

void KbfxConfigDlgFonts::KbfxLineColorSelected(const QColor & color)
{
  ConfigInit().m_KbfxGlobalChange = TRUE;
  ConfigInit().m_lineColor = color;

  kdDebug() << "Line color: "
            << ConfigInit().m_lineColor
            << endl;
}

void KbfxConfigDlgFonts::KbfxCategoryColorSelected(const QColor &color)
{
  ConfigInit().m_KbfxGlobalChange = TRUE;
  ConfigInit().m_fontIndexColor = color;

  kdDebug() << "Category color: "
            << ConfigInit().m_fontIndexColor
            << endl;
}

void KbfxConfigDlgFonts::KbfxNameColorSelected(const QColor &color)
{
  ConfigInit().m_KbfxGlobalChange = TRUE;
  ConfigInit().m_userNameColor = color;

  kdDebug() << "User color: "
            << ConfigInit().m_userNameColor
            << endl;
}

void KbfxConfigDlgFonts::KbfxSeparatorColorSelected(const QColor &color)
{
  ConfigInit().m_KbfxGlobalChange = TRUE;
  ConfigInit().m_sepNameColor = color;

  kdDebug() << "Separator color: "
            << ConfigInit().m_sepNameColor
            << endl;
}

void KbfxConfigDlgFonts::KbfxExportFileAction()
{
/*
  KFileDialog KbfxExportFontRcDialog(QString::null,
                                     "*.*|" + tr2i18n("All files"),
                                     0,
                                     0,
                                     TRUE);
  KbfxExportFontRcDialog.setOperationMode(KFileDialog::Saving);
  KbfxExportFontRcDialog.setCaption(tr2i18n("Select Folder to export kbfxfontrc file"));
  KbfxExportFontRcDialog.setMode(KFile::Directory);

  if(!KbfxExportFontRcDialog.exec()) return;

  QString KbfxExportFontRcDialogURL = KbfxExportFontRcDialog.selectedURL().path();
*/

  QString KbfxExportFontRcDialogURL = KFileDialog::getExistingDirectory(
                                      QString::null,
                                      0,
                                      tr2i18n("Select folder to export kbfxfontrc file")).append("/kbfxfontrc");

  kdDebug() << "Selected export file is: "
            << KbfxExportFontRcDialogURL
            << endl;

  KConfig *fontconfig = new KConfig(KbfxExportFontRcDialogURL);

  fontconfig->setGroup("Fonts");
  fontconfig->writeEntry("ApplicationText", ConfigInit().m_fontAppNameColor);
  fontconfig->writeEntry("CommentText", ConfigInit().m_fontAppCommentColor);
  fontconfig->writeEntry("LineColor", ConfigInit().m_lineColor);
  fontconfig->writeEntry("GroupText", ConfigInit().m_fontIndexColor);
  fontconfig->writeEntry("FontSize", ConfigInit().m_fontSize);
  fontconfig->writeEntry("UserName", ConfigInit().m_userNameColor);
  fontconfig->writeEntry("SeparatorColor", ConfigInit().m_sepNameColor);
  fontconfig->sync();

  delete fontconfig;
}
