/******************************************************************************
 *   Copyright (C) 2006 PhobosK <phobosk@mail.kbfx.org>                       *
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This package is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this package; if not, write to the Free Software              *
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA *
 ******************************************************************************/

#include "kbfxpixmaplabel.h"

KbfxPixmapLabel::KbfxPixmapLabel(QWidget *parent, const char *name, WFlags fl)
  : QLabel(parent, name, fl)
{
  // setFrameShape(QLabel::WinPanel);
  // setFrameShadow(QLabel::Sunken);
  setFrameShape(QLabel::LineEditPanel);
  setFrameShadow(QLabel::Plain);
  setScaledContents(FALSE);
  setAlignment(int(QLabel::WordBreak | QLabel::AlignCenter));
}

/* processing drag events over label */
void KbfxPixmapLabel::dragEnterEvent(QDragEnterEvent *mouseDragEnterEvent)
{
  kdDebug() << "Accepting drag..." << endl;
  mouseDragEnterEvent->accept(QTextDrag::canDecode(mouseDragEnterEvent));
}

/* processing drop events over label */
void KbfxPixmapLabel::dropEvent(QDropEvent *mouseDropEvent)
{
  QString text;

  if(QTextDrag::decode(mouseDropEvent,text))
  {
    if(text.startsWith("file://")) text.remove("file://");

    kdDebug() << "Dropping drag..." << text << endl;

    emit targetDrop(text);
  }
}

#include "kbfxpixmaplabel.moc"
